package zio.aws.cloudformation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  TypeVersionId,
  PublicVersionNumber,
  TypeArn,
  Timestamp,
  IsDefaultVersion,
  Description,
  TypeName
}
import scala.jdk.CollectionConverters._
final case class TypeVersionSummary(
    `type`: Optional[zio.aws.cloudformation.model.RegistryType] =
      Optional.Absent,
    typeName: Optional[TypeName] = Optional.Absent,
    versionId: Optional[TypeVersionId] = Optional.Absent,
    isDefaultVersion: Optional[IsDefaultVersion] = Optional.Absent,
    arn: Optional[TypeArn] = Optional.Absent,
    timeCreated: Optional[Timestamp] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    publicVersionNumber: Optional[PublicVersionNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.TypeVersionSummary = {
    import TypeVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.TypeVersionSummary
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        versionId.map(value => TypeVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        isDefaultVersion.map(value =>
          IsDefaultVersion.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .optionallyWith(
        arn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        timeCreated.map(value => Timestamp.unwrap(value): Instant)
      )(_.timeCreated)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        publicVersionNumber.map(value =>
          PublicVersionNumber.unwrap(value): java.lang.String
        )
      )(_.publicVersionNumber)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.TypeVersionSummary.ReadOnly =
    zio.aws.cloudformation.model.TypeVersionSummary.wrap(buildAwsValue())
}
object TypeVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.TypeVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.TypeVersionSummary =
      zio.aws.cloudformation.model.TypeVersionSummary(
        `type`.map(value => value),
        typeName.map(value => value),
        versionId.map(value => value),
        isDefaultVersion.map(value => value),
        arn.map(value => value),
        timeCreated.map(value => value),
        description.map(value => value),
        publicVersionNumber.map(value => value)
      )
    def `type`: Optional[zio.aws.cloudformation.model.RegistryType]
    def typeName: Optional[TypeName]
    def versionId: Optional[TypeVersionId]
    def isDefaultVersion: Optional[IsDefaultVersion]
    def arn: Optional[TypeArn]
    def timeCreated: Optional[Timestamp]
    def description: Optional[Description]
    def publicVersionNumber: Optional[PublicVersionNumber]
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getIsDefaultVersion: ZIO[Any, AwsError, IsDefaultVersion] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
    def getArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getTimeCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timeCreated", timeCreated)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getPublicVersionNumber: ZIO[Any, AwsError, PublicVersionNumber] =
      AwsError.unwrapOptionField("publicVersionNumber", publicVersionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.TypeVersionSummary
  ) extends zio.aws.cloudformation.model.TypeVersionSummary.ReadOnly {
    override val `type`: Optional[zio.aws.cloudformation.model.RegistryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val typeName: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val versionId: Optional[TypeVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeVersionId(value)
      )
    override val isDefaultVersion: Optional[IsDefaultVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isDefaultVersion())
        .map(value =>
          zio.aws.cloudformation.model.primitives.IsDefaultVersion(value)
        )
    override val arn: Optional[TypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val timeCreated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timeCreated())
      .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val publicVersionNumber: Optional[PublicVersionNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicVersionNumber())
        .map(value =>
          zio.aws.cloudformation.model.primitives.PublicVersionNumber(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.TypeVersionSummary
  ): zio.aws.cloudformation.model.TypeVersionSummary.ReadOnly = new Wrapper(
    impl
  )
}
