package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.ClientRequestToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStackSetResponse(
    operationId: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.UpdateStackSetResponse = {
    import UpdateStackSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.UpdateStackSetResponse
      .builder()
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.UpdateStackSetResponse.ReadOnly =
    zio.aws.cloudformation.model.UpdateStackSetResponse.wrap(buildAwsValue())
}
object UpdateStackSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.UpdateStackSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.UpdateStackSetResponse =
      zio.aws.cloudformation.model
        .UpdateStackSetResponse(operationId.map(value => value))
    def operationId: Optional[ClientRequestToken]
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackSetResponse
  ) extends zio.aws.cloudformation.model.UpdateStackSetResponse.ReadOnly {
    override val operationId: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackSetResponse
  ): zio.aws.cloudformation.model.UpdateStackSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
