package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  StackNameOrId,
  EnableTerminationProtection
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateTerminationProtectionRequest(
    enableTerminationProtection: EnableTerminationProtection,
    stackName: StackNameOrId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest = {
    import UpdateTerminationProtectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest
      .builder()
      .enableTerminationProtection(
        EnableTerminationProtection.unwrap(
          enableTerminationProtection
        ): java.lang.Boolean
      )
      .stackName(StackNameOrId.unwrap(stackName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.UpdateTerminationProtectionRequest.ReadOnly =
    zio.aws.cloudformation.model.UpdateTerminationProtectionRequest
      .wrap(buildAwsValue())
}
object UpdateTerminationProtectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.UpdateTerminationProtectionRequest =
      zio.aws.cloudformation.model.UpdateTerminationProtectionRequest(
        enableTerminationProtection,
        stackName
      )
    def enableTerminationProtection: EnableTerminationProtection
    def stackName: StackNameOrId
    def getEnableTerminationProtection
        : ZIO[Any, Nothing, EnableTerminationProtection] =
      ZIO.succeed(enableTerminationProtection)
    def getStackName: ZIO[Any, Nothing, StackNameOrId] = ZIO.succeed(stackName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest
  ) extends zio.aws.cloudformation.model.UpdateTerminationProtectionRequest.ReadOnly {
    override val enableTerminationProtection: EnableTerminationProtection =
      zio.aws.cloudformation.model.primitives
        .EnableTerminationProtection(impl.enableTerminationProtection())
    override val stackName: StackNameOrId =
      zio.aws.cloudformation.model.primitives.StackNameOrId(impl.stackName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest
  ): zio.aws.cloudformation.model.UpdateTerminationProtectionRequest.ReadOnly =
    new Wrapper(impl)
}
