package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{TemplateURL, TemplateBody}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidateTemplateRequest(
    templateBody: Optional[TemplateBody] = Optional.Absent,
    templateURL: Optional[TemplateURL] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest = {
    import ValidateTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest
      .builder()
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        templateURL.map(value => TemplateURL.unwrap(value): java.lang.String)
      )(_.templateURL)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ValidateTemplateRequest.ReadOnly =
    zio.aws.cloudformation.model.ValidateTemplateRequest.wrap(buildAwsValue())
}
object ValidateTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ValidateTemplateRequest =
      zio.aws.cloudformation.model.ValidateTemplateRequest(
        templateBody.map(value => value),
        templateURL.map(value => value)
      )
    def templateBody: Optional[TemplateBody]
    def templateURL: Optional[TemplateURL]
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateURL: ZIO[Any, AwsError, TemplateURL] =
      AwsError.unwrapOptionField("templateURL", templateURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest
  ) extends zio.aws.cloudformation.model.ValidateTemplateRequest.ReadOnly {
    override val templateBody: Optional[TemplateBody] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val templateURL: Optional[TemplateURL] = zio.aws.core.internal
      .optionalFromNullable(impl.templateURL())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateURL(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest
  ): zio.aws.cloudformation.model.ValidateTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
