package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  TransformName,
  CapabilitiesReason,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidateTemplateResponse(
    parameters: Optional[
      Iterable[zio.aws.cloudformation.model.TemplateParameter]
    ] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    capabilities: Optional[Iterable[zio.aws.cloudformation.model.Capability]] =
      Optional.Absent,
    capabilitiesReason: Optional[CapabilitiesReason] = Optional.Absent,
    declaredTransforms: Optional[Iterable[TransformName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ValidateTemplateResponse = {
    import ValidateTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ValidateTemplateResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        capabilitiesReason.map(value =>
          CapabilitiesReason.unwrap(value): java.lang.String
        )
      )(_.capabilitiesReason)
      .optionallyWith(
        declaredTransforms.map(value =>
          value.map { item =>
            TransformName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.declaredTransforms)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ValidateTemplateResponse.ReadOnly =
    zio.aws.cloudformation.model.ValidateTemplateResponse.wrap(buildAwsValue())
}
object ValidateTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ValidateTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ValidateTemplateResponse =
      zio.aws.cloudformation.model.ValidateTemplateResponse(
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value),
        capabilities.map(value => value),
        capabilitiesReason.map(value => value),
        declaredTransforms.map(value => value)
      )
    def parameters: Optional[
      List[zio.aws.cloudformation.model.TemplateParameter.ReadOnly]
    ]
    def description: Optional[Description]
    def capabilities: Optional[List[zio.aws.cloudformation.model.Capability]]
    def capabilitiesReason: Optional[CapabilitiesReason]
    def declaredTransforms: Optional[List[TransformName]]
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.TemplateParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getCapabilitiesReason: ZIO[Any, AwsError, CapabilitiesReason] =
      AwsError.unwrapOptionField("capabilitiesReason", capabilitiesReason)
    def getDeclaredTransforms: ZIO[Any, AwsError, List[TransformName]] =
      AwsError.unwrapOptionField("declaredTransforms", declaredTransforms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ValidateTemplateResponse
  ) extends zio.aws.cloudformation.model.ValidateTemplateResponse.ReadOnly {
    override val parameters: Optional[
      List[zio.aws.cloudformation.model.TemplateParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.TemplateParameter.wrap(item)
        }.toList
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val capabilities
        : Optional[List[zio.aws.cloudformation.model.Capability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Capability.wrap(item)
          }.toList
        )
    override val capabilitiesReason: Optional[CapabilitiesReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilitiesReason())
        .map(value =>
          zio.aws.cloudformation.model.primitives.CapabilitiesReason(value)
        )
    override val declaredTransforms: Optional[List[TransformName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.declaredTransforms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.TransformName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ValidateTemplateResponse
  ): zio.aws.cloudformation.model.ValidateTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
