package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait VersionBump {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.VersionBump
}
object VersionBump {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.VersionBump
  ): zio.aws.cloudformation.model.VersionBump = value match {
    case software.amazon.awssdk.services.cloudformation.model.VersionBump.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.VersionBump.MAJOR =>
      val r = MAJOR
      r
    case software.amazon.awssdk.services.cloudformation.model.VersionBump.MINOR =>
      val r = MINOR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.VersionBump {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.VersionBump =
      software.amazon.awssdk.services.cloudformation.model.VersionBump.UNKNOWN_TO_SDK_VERSION
  }
  case object MAJOR extends zio.aws.cloudformation.model.VersionBump {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.VersionBump =
      software.amazon.awssdk.services.cloudformation.model.VersionBump.MAJOR
  }
  case object MINOR extends zio.aws.cloudformation.model.VersionBump {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.VersionBump =
      software.amazon.awssdk.services.cloudformation.model.VersionBump.MINOR
  }
}
