package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.ResourceType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Warnings(
    unrecognizedResourceTypes: Optional[Iterable[ResourceType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.Warnings = {
    import Warnings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.Warnings
      .builder()
      .optionallyWith(
        unrecognizedResourceTypes.map(value =>
          value.map { item =>
            ResourceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.unrecognizedResourceTypes)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.Warnings.ReadOnly =
    zio.aws.cloudformation.model.Warnings.wrap(buildAwsValue())
}
object Warnings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.Warnings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.Warnings =
      zio.aws.cloudformation.model
        .Warnings(unrecognizedResourceTypes.map(value => value))
    def unrecognizedResourceTypes: Optional[List[ResourceType]]
    def getUnrecognizedResourceTypes: ZIO[Any, AwsError, List[ResourceType]] =
      AwsError.unwrapOptionField(
        "unrecognizedResourceTypes",
        unrecognizedResourceTypes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.Warnings
  ) extends zio.aws.cloudformation.model.Warnings.ReadOnly {
    override val unrecognizedResourceTypes: Optional[List[ResourceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unrecognizedResourceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.ResourceType(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.Warnings
  ): zio.aws.cloudformation.model.Warnings.ReadOnly = new Wrapper(impl)
}
