package zio.aws.cloudwatch
import zio.aws.cloudwatch.model.PutAnomalyDetectorResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.cloudwatch.paginators.{
  ListMetricsPublisher,
  GetMetricDataPublisher,
  DescribeAlarmsPublisher
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import zio.aws.cloudwatch.model.{
  DescribeAlarmsForMetricRequest,
  DescribeInsightRulesRequest,
  DeleteDashboardsRequest,
  DescribeAlarmHistoryRequest,
  ListDashboardsRequest,
  DeleteAlarmsRequest,
  ListManagedInsightRulesRequest,
  StopMetricStreamsRequest,
  PutMetricStreamRequest,
  SetAlarmStateRequest,
  PutMetricDataRequest,
  DeleteAnomalyDetectorRequest,
  ListTagsForResourceRequest,
  PutInsightRuleRequest,
  PutMetricAlarmRequest,
  PutDashboardRequest,
  StartMetricStreamsRequest,
  EnableAlarmActionsRequest,
  PutCompositeAlarmRequest,
  DescribeAnomalyDetectorsRequest,
  GetDashboardRequest,
  GetMetricStreamRequest,
  ListMetricsRequest,
  GetMetricStatisticsRequest,
  ListMetricStreamsRequest,
  UntagResourceRequest,
  DisableAlarmActionsRequest,
  GetMetricDataRequest,
  EnableInsightRulesRequest,
  DeleteMetricStreamRequest,
  GetMetricWidgetImageRequest,
  GetInsightRuleReportRequest,
  PutManagedInsightRulesRequest,
  DeleteInsightRulesRequest,
  DescribeAlarmsRequest,
  TagResourceRequest,
  PutAnomalyDetectorRequest,
  DisableInsightRulesRequest
}
import software.amazon.awssdk.services.cloudwatch.{
  CloudWatchAsyncClientBuilder,
  CloudWatchAsyncClient
}
import software.amazon.awssdk.services.cloudwatch.model.{
  AlarmHistoryItem,
  PutInsightRuleResponse,
  EnableInsightRulesResponse,
  MetricAlarm,
  DeleteInsightRulesResponse,
  StartMetricStreamsResponse,
  PutCompositeAlarmResponse,
  DashboardEntry,
  MetricDataResult,
  DescribeAlarmsForMetricResponse,
  DescribeAlarmHistoryResponse,
  GetMetricWidgetImageResponse,
  DescribeAlarmsResponse,
  ManagedRuleDescription,
  ListManagedInsightRulesResponse,
  PutAnomalyDetectorResponse,
  GetMetricStatisticsResponse,
  GetMetricDataResponse,
  DeleteAlarmsResponse,
  ListDashboardsResponse,
  MetricStreamEntry,
  DescribeInsightRulesResponse,
  ListMetricsResponse,
  DeleteDashboardsResponse,
  SetAlarmStateResponse,
  PutMetricDataResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  PutManagedInsightRulesResponse,
  DeleteMetricStreamResponse,
  EnableAlarmActionsResponse,
  PutMetricAlarmResponse,
  DescribeAnomalyDetectorsResponse,
  StopMetricStreamsResponse,
  ListMetricStreamsResponse,
  AnomalyDetector,
  GetInsightRuleReportResponse,
  PutDashboardResponse,
  GetDashboardResponse,
  DeleteAnomalyDetectorResponse,
  DisableAlarmActionsResponse,
  InsightRule,
  Metric,
  GetMetricStreamResponse,
  DisableInsightRulesResponse,
  TagResourceResponse,
  PutMetricStreamResponse
}
import scala.jdk.CollectionConverters._
trait CloudWatch extends AspectSupport[CloudWatch] {
  val api: CloudWatchAsyncClient
  def deleteAnomalyDetector(request: DeleteAnomalyDetectorRequest): IO[
    AwsError,
    zio.aws.cloudwatch.model.DeleteAnomalyDetectorResponse.ReadOnly
  ]
  def putMetricAlarm(request: PutMetricAlarmRequest): IO[AwsError, Unit]
  def listManagedInsightRules(request: ListManagedInsightRulesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.cloudwatch.model.ManagedRuleDescription.ReadOnly
  ]
  def listManagedInsightRulesPaginated(
      request: ListManagedInsightRulesRequest
  ): IO[
    AwsError,
    zio.aws.cloudwatch.model.ListManagedInsightRulesResponse.ReadOnly
  ]
  def listMetricStreams(
      request: ListMetricStreamsRequest
  ): ZStream[Any, AwsError, zio.aws.cloudwatch.model.MetricStreamEntry.ReadOnly]
  def listMetricStreamsPaginated(
      request: ListMetricStreamsRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.ListMetricStreamsResponse.ReadOnly]
  def describeAlarmsForMetric(request: DescribeAlarmsForMetricRequest): IO[
    AwsError,
    zio.aws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly
  ]
  def describeAlarms(
      request: DescribeAlarmsRequest
  ): ZStream[Any, AwsError, zio.aws.cloudwatch.model.MetricAlarm.ReadOnly]
  def describeAlarmsPaginated(
      request: DescribeAlarmsRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.DescribeAlarmsResponse.ReadOnly]
  def putManagedInsightRules(request: PutManagedInsightRulesRequest): IO[
    AwsError,
    zio.aws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly
  ]
  def disableAlarmActions(
      request: DisableAlarmActionsRequest
  ): IO[AwsError, Unit]
  def deleteInsightRules(
      request: DeleteInsightRulesRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.DeleteInsightRulesResponse.ReadOnly]
  def describeInsightRules(
      request: DescribeInsightRulesRequest
  ): ZStream[Any, AwsError, zio.aws.cloudwatch.model.InsightRule.ReadOnly]
  def describeInsightRulesPaginated(request: DescribeInsightRulesRequest): IO[
    AwsError,
    zio.aws.cloudwatch.model.DescribeInsightRulesResponse.ReadOnly
  ]
  def putDashboard(
      request: PutDashboardRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.PutDashboardResponse.ReadOnly]
  def describeAlarmHistory(
      request: DescribeAlarmHistoryRequest
  ): ZStream[Any, AwsError, zio.aws.cloudwatch.model.AlarmHistoryItem.ReadOnly]
  def describeAlarmHistoryPaginated(request: DescribeAlarmHistoryRequest): IO[
    AwsError,
    zio.aws.cloudwatch.model.DescribeAlarmHistoryResponse.ReadOnly
  ]
  def stopMetricStreams(
      request: StopMetricStreamsRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.StopMetricStreamsResponse.ReadOnly]
  def getMetricStream(
      request: GetMetricStreamRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.GetMetricStreamResponse.ReadOnly]
  def getMetricWidgetImage(request: GetMetricWidgetImageRequest): IO[
    AwsError,
    zio.aws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly
  ]
  def getMetricData(
      request: GetMetricDataRequest
  ): ZStream[Any, AwsError, zio.aws.cloudwatch.model.MetricDataResult.ReadOnly]
  def getMetricDataPaginated(
      request: GetMetricDataRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.GetMetricDataResponse.ReadOnly]
  def getInsightRuleReport(request: GetInsightRuleReportRequest): IO[
    AwsError,
    zio.aws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly
  ]
  def getDashboard(
      request: GetDashboardRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.GetDashboardResponse.ReadOnly]
  def enableInsightRules(
      request: EnableInsightRulesRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.EnableInsightRulesResponse.ReadOnly]
  def deleteMetricStream(
      request: DeleteMetricStreamRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.DeleteMetricStreamResponse.ReadOnly]
  def enableAlarmActions(request: EnableAlarmActionsRequest): IO[AwsError, Unit]
  def listDashboards(
      request: ListDashboardsRequest
  ): ZStream[Any, AwsError, zio.aws.cloudwatch.model.DashboardEntry.ReadOnly]
  def listDashboardsPaginated(
      request: ListDashboardsRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.ListDashboardsResponse.ReadOnly]
  def putMetricStream(
      request: PutMetricStreamRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.PutMetricStreamResponse.ReadOnly]
  def deleteDashboards(
      request: DeleteDashboardsRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.DeleteDashboardsResponse.ReadOnly]
  def putInsightRule(
      request: PutInsightRuleRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.PutInsightRuleResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.UntagResourceResponse.ReadOnly]
  def listMetrics(
      request: ListMetricsRequest
  ): ZStream[Any, AwsError, zio.aws.cloudwatch.model.Metric.ReadOnly]
  def listMetricsPaginated(
      request: ListMetricsRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.ListMetricsResponse.ReadOnly]
  def putCompositeAlarm(request: PutCompositeAlarmRequest): IO[AwsError, Unit]
  def putMetricData(request: PutMetricDataRequest): IO[AwsError, Unit]
  def startMetricStreams(
      request: StartMetricStreamsRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.StartMetricStreamsResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.TagResourceResponse.ReadOnly]
  def getMetricStatistics(
      request: GetMetricStatisticsRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly]
  def putAnomalyDetector(
      request: PutAnomalyDetectorRequest
  ): IO[AwsError, ReadOnly]
  def describeAnomalyDetectors(
      request: DescribeAnomalyDetectorsRequest
  ): ZStream[Any, AwsError, zio.aws.cloudwatch.model.AnomalyDetector.ReadOnly]
  def describeAnomalyDetectorsPaginated(
      request: DescribeAnomalyDetectorsRequest
  ): IO[
    AwsError,
    zio.aws.cloudwatch.model.DescribeAnomalyDetectorsResponse.ReadOnly
  ]
  def deleteAlarms(request: DeleteAlarmsRequest): IO[AwsError, Unit]
  def disableInsightRules(
      request: DisableInsightRulesRequest
  ): IO[AwsError, zio.aws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly]
  def setAlarmState(request: SetAlarmStateRequest): IO[AwsError, Unit]
}
object CloudWatch {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CloudWatch] = customized(
    identity
  )
  def customized(
      customization: CloudWatchAsyncClientBuilder => CloudWatchAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CloudWatch] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: CloudWatchAsyncClientBuilder => CloudWatchAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, CloudWatch] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = CloudWatchAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CloudWatchAsyncClient, CloudWatchAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[CloudWatchAsyncClient, CloudWatchAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new CloudWatchImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class CloudWatchImpl[R](
      override val api: CloudWatchAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CloudWatch
      with AwsServiceBase[R] {
    override val serviceName: String = "CloudWatch"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CloudWatchImpl[R1] = new CloudWatchImpl(api, newAspect, r)
    def deleteAnomalyDetector(request: DeleteAnomalyDetectorRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.DeleteAnomalyDetectorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorRequest,
      DeleteAnomalyDetectorResponse
    ]("deleteAnomalyDetector", api.deleteAnomalyDetector)(
      request.buildAwsValue()
    ).map(zio.aws.cloudwatch.model.DeleteAnomalyDetectorResponse.wrap)
      .provideEnvironment(r)
    def putMetricAlarm(request: PutMetricAlarmRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest,
        PutMetricAlarmResponse
      ]("putMetricAlarm", api.putMetricAlarm)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listManagedInsightRules(
        request: ListManagedInsightRulesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.cloudwatch.model.ManagedRuleDescription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest,
      ListManagedInsightRulesResponse,
      ManagedRuleDescription
    ](
      "listManagedInsightRules",
      api.listManagedInsightRules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.managedRules().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudwatch.model.ManagedRuleDescription.wrap(item))
      .provideEnvironment(r)
    def listManagedInsightRulesPaginated(
        request: ListManagedInsightRulesRequest
    ): IO[
      AwsError,
      zio.aws.cloudwatch.model.ListManagedInsightRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest,
      ListManagedInsightRulesResponse
    ]("listManagedInsightRules", api.listManagedInsightRules)(
      request.buildAwsValue()
    ).map(zio.aws.cloudwatch.model.ListManagedInsightRulesResponse.wrap)
      .provideEnvironment(r)
    def listMetricStreams(request: ListMetricStreamsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudwatch.model.MetricStreamEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsRequest,
      ListMetricStreamsResponse,
      MetricStreamEntry
    ](
      "listMetricStreams",
      api.listMetricStreams,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.entries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudwatch.model.MetricStreamEntry.wrap(item))
      .provideEnvironment(r)
    def listMetricStreamsPaginated(request: ListMetricStreamsRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.ListMetricStreamsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsRequest,
      ListMetricStreamsResponse
    ]("listMetricStreams", api.listMetricStreams)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.ListMetricStreamsResponse.wrap)
      .provideEnvironment(r)
    def describeAlarmsForMetric(request: DescribeAlarmsForMetricRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest,
      DescribeAlarmsForMetricResponse
    ]("describeAlarmsForMetric", api.describeAlarmsForMetric)(
      request.buildAwsValue()
    ).map(zio.aws.cloudwatch.model.DescribeAlarmsForMetricResponse.wrap)
      .provideEnvironment(r)
    def describeAlarms(
        request: DescribeAlarmsRequest
    ): ZStream[Any, AwsError, zio.aws.cloudwatch.model.MetricAlarm.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest,
        MetricAlarm,
        DescribeAlarmsPublisher
      ]("describeAlarms", api.describeAlarmsPaginator, _.metricAlarms())(
        request.buildAwsValue()
      ).map(item => zio.aws.cloudwatch.model.MetricAlarm.wrap(item))
        .provideEnvironment(r)
    def describeAlarmsPaginated(
        request: DescribeAlarmsRequest
    ): IO[AwsError, zio.aws.cloudwatch.model.DescribeAlarmsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest,
        DescribeAlarmsResponse
      ]("describeAlarms", api.describeAlarms)(request.buildAwsValue())
        .map(zio.aws.cloudwatch.model.DescribeAlarmsResponse.wrap)
        .provideEnvironment(r)
    def putManagedInsightRules(request: PutManagedInsightRulesRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesRequest,
      PutManagedInsightRulesResponse
    ]("putManagedInsightRules", api.putManagedInsightRules)(
      request.buildAwsValue()
    ).map(zio.aws.cloudwatch.model.PutManagedInsightRulesResponse.wrap)
      .provideEnvironment(r)
    def disableAlarmActions(
        request: DisableAlarmActionsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest,
      DisableAlarmActionsResponse
    ]("disableAlarmActions", api.disableAlarmActions)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteInsightRules(request: DeleteInsightRulesRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.DeleteInsightRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest,
      DeleteInsightRulesResponse
    ]("deleteInsightRules", api.deleteInsightRules)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.DeleteInsightRulesResponse.wrap)
      .provideEnvironment(r)
    def describeInsightRules(
        request: DescribeInsightRulesRequest
    ): ZStream[Any, AwsError, zio.aws.cloudwatch.model.InsightRule.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest,
        DescribeInsightRulesResponse,
        InsightRule
      ](
        "describeInsightRules",
        api.describeInsightRules,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.insightRules().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.cloudwatch.model.InsightRule.wrap(item))
        .provideEnvironment(r)
    def describeInsightRulesPaginated(request: DescribeInsightRulesRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.DescribeInsightRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest,
      DescribeInsightRulesResponse
    ]("describeInsightRules", api.describeInsightRules)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.DescribeInsightRulesResponse.wrap)
      .provideEnvironment(r)
    def putDashboard(
        request: PutDashboardRequest
    ): IO[AwsError, zio.aws.cloudwatch.model.PutDashboardResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest,
        PutDashboardResponse
      ]("putDashboard", api.putDashboard)(request.buildAwsValue())
        .map(zio.aws.cloudwatch.model.PutDashboardResponse.wrap)
        .provideEnvironment(r)
    def describeAlarmHistory(request: DescribeAlarmHistoryRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudwatch.model.AlarmHistoryItem.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest,
      DescribeAlarmHistoryResponse,
      AlarmHistoryItem
    ](
      "describeAlarmHistory",
      api.describeAlarmHistory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.alarmHistoryItems().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudwatch.model.AlarmHistoryItem.wrap(item))
      .provideEnvironment(r)
    def describeAlarmHistoryPaginated(request: DescribeAlarmHistoryRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.DescribeAlarmHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest,
      DescribeAlarmHistoryResponse
    ]("describeAlarmHistory", api.describeAlarmHistory)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.DescribeAlarmHistoryResponse.wrap)
      .provideEnvironment(r)
    def stopMetricStreams(request: StopMetricStreamsRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.StopMetricStreamsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsRequest,
      StopMetricStreamsResponse
    ]("stopMetricStreams", api.stopMetricStreams)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.StopMetricStreamsResponse.wrap)
      .provideEnvironment(r)
    def getMetricStream(
        request: GetMetricStreamRequest
    ): IO[AwsError, zio.aws.cloudwatch.model.GetMetricStreamResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamRequest,
        GetMetricStreamResponse
      ]("getMetricStream", api.getMetricStream)(request.buildAwsValue())
        .map(zio.aws.cloudwatch.model.GetMetricStreamResponse.wrap)
        .provideEnvironment(r)
    def getMetricWidgetImage(request: GetMetricWidgetImageRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest,
      GetMetricWidgetImageResponse
    ]("getMetricWidgetImage", api.getMetricWidgetImage)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.GetMetricWidgetImageResponse.wrap)
      .provideEnvironment(r)
    def getMetricData(request: GetMetricDataRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudwatch.model.MetricDataResult.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest,
      MetricDataResult,
      GetMetricDataPublisher
    ]("getMetricData", api.getMetricDataPaginator, _.metricDataResults())(
      request.buildAwsValue()
    ).map(item => zio.aws.cloudwatch.model.MetricDataResult.wrap(item))
      .provideEnvironment(r)
    def getMetricDataPaginated(
        request: GetMetricDataRequest
    ): IO[AwsError, zio.aws.cloudwatch.model.GetMetricDataResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest,
        GetMetricDataResponse
      ]("getMetricData", api.getMetricData)(request.buildAwsValue())
        .map(zio.aws.cloudwatch.model.GetMetricDataResponse.wrap)
        .provideEnvironment(r)
    def getInsightRuleReport(request: GetInsightRuleReportRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest,
      GetInsightRuleReportResponse
    ]("getInsightRuleReport", api.getInsightRuleReport)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.GetInsightRuleReportResponse.wrap)
      .provideEnvironment(r)
    def getDashboard(
        request: GetDashboardRequest
    ): IO[AwsError, zio.aws.cloudwatch.model.GetDashboardResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest,
        GetDashboardResponse
      ]("getDashboard", api.getDashboard)(request.buildAwsValue())
        .map(zio.aws.cloudwatch.model.GetDashboardResponse.wrap)
        .provideEnvironment(r)
    def enableInsightRules(request: EnableInsightRulesRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.EnableInsightRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest,
      EnableInsightRulesResponse
    ]("enableInsightRules", api.enableInsightRules)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.EnableInsightRulesResponse.wrap)
      .provideEnvironment(r)
    def deleteMetricStream(request: DeleteMetricStreamRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.DeleteMetricStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamRequest,
      DeleteMetricStreamResponse
    ]("deleteMetricStream", api.deleteMetricStream)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.DeleteMetricStreamResponse.wrap)
      .provideEnvironment(r)
    def enableAlarmActions(
        request: EnableAlarmActionsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest,
      EnableAlarmActionsResponse
    ]("enableAlarmActions", api.enableAlarmActions)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listDashboards(request: ListDashboardsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.cloudwatch.model.DashboardEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest,
      ListDashboardsResponse,
      DashboardEntry
    ](
      "listDashboards",
      api.listDashboards,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.dashboardEntries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudwatch.model.DashboardEntry.wrap(item))
      .provideEnvironment(r)
    def listDashboardsPaginated(
        request: ListDashboardsRequest
    ): IO[AwsError, zio.aws.cloudwatch.model.ListDashboardsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest,
        ListDashboardsResponse
      ]("listDashboards", api.listDashboards)(request.buildAwsValue())
        .map(zio.aws.cloudwatch.model.ListDashboardsResponse.wrap)
        .provideEnvironment(r)
    def putMetricStream(
        request: PutMetricStreamRequest
    ): IO[AwsError, zio.aws.cloudwatch.model.PutMetricStreamResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamRequest,
        PutMetricStreamResponse
      ]("putMetricStream", api.putMetricStream)(request.buildAwsValue())
        .map(zio.aws.cloudwatch.model.PutMetricStreamResponse.wrap)
        .provideEnvironment(r)
    def deleteDashboards(request: DeleteDashboardsRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.DeleteDashboardsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest,
      DeleteDashboardsResponse
    ]("deleteDashboards", api.deleteDashboards)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.DeleteDashboardsResponse.wrap)
      .provideEnvironment(r)
    def putInsightRule(
        request: PutInsightRuleRequest
    ): IO[AwsError, zio.aws.cloudwatch.model.PutInsightRuleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest,
        PutInsightRuleResponse
      ]("putInsightRule", api.putInsightRule)(request.buildAwsValue())
        .map(zio.aws.cloudwatch.model.PutInsightRuleResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.cloudwatch.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.cloudwatch.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listMetrics(
        request: ListMetricsRequest
    ): ZStream[Any, AwsError, zio.aws.cloudwatch.model.Metric.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest,
        Metric,
        ListMetricsPublisher
      ]("listMetrics", api.listMetricsPaginator, _.metrics())(
        request.buildAwsValue()
      ).map(item => zio.aws.cloudwatch.model.Metric.wrap(item))
        .provideEnvironment(r)
    def listMetricsPaginated(
        request: ListMetricsRequest
    ): IO[AwsError, zio.aws.cloudwatch.model.ListMetricsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest,
        ListMetricsResponse
      ]("listMetrics", api.listMetrics)(request.buildAwsValue())
        .map(zio.aws.cloudwatch.model.ListMetricsResponse.wrap)
        .provideEnvironment(r)
    def putCompositeAlarm(
        request: PutCompositeAlarmRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmRequest,
      PutCompositeAlarmResponse
    ]("putCompositeAlarm", api.putCompositeAlarm)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def putMetricData(request: PutMetricDataRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest,
        PutMetricDataResponse
      ]("putMetricData", api.putMetricData)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def startMetricStreams(request: StartMetricStreamsRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.StartMetricStreamsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsRequest,
      StartMetricStreamsResponse
    ]("startMetricStreams", api.startMetricStreams)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.StartMetricStreamsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.cloudwatch.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.cloudwatch.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getMetricStatistics(request: GetMetricStatisticsRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest,
      GetMetricStatisticsResponse
    ]("getMetricStatistics", api.getMetricStatistics)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.GetMetricStatisticsResponse.wrap)
      .provideEnvironment(r)
    def putAnomalyDetector(
        request: PutAnomalyDetectorRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.PutAnomalyDetectorRequest,
      PutAnomalyDetectorResponse
    ]("putAnomalyDetector", api.putAnomalyDetector)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.PutAnomalyDetectorResponse.wrap)
      .provideEnvironment(r)
    def describeAnomalyDetectors(
        request: DescribeAnomalyDetectorsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.cloudwatch.model.AnomalyDetector.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest,
      DescribeAnomalyDetectorsResponse,
      AnomalyDetector
    ](
      "describeAnomalyDetectors",
      api.describeAnomalyDetectors,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.anomalyDetectors().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.cloudwatch.model.AnomalyDetector.wrap(item))
      .provideEnvironment(r)
    def describeAnomalyDetectorsPaginated(
        request: DescribeAnomalyDetectorsRequest
    ): IO[
      AwsError,
      zio.aws.cloudwatch.model.DescribeAnomalyDetectorsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest,
      DescribeAnomalyDetectorsResponse
    ]("describeAnomalyDetectors", api.describeAnomalyDetectors)(
      request.buildAwsValue()
    ).map(zio.aws.cloudwatch.model.DescribeAnomalyDetectorsResponse.wrap)
      .provideEnvironment(r)
    def deleteAlarms(request: DeleteAlarmsRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest,
        DeleteAlarmsResponse
      ]("deleteAlarms", api.deleteAlarms)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def disableInsightRules(request: DisableInsightRulesRequest): IO[
      AwsError,
      zio.aws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest,
      DisableInsightRulesResponse
    ]("disableInsightRules", api.disableInsightRules)(request.buildAwsValue())
      .map(zio.aws.cloudwatch.model.DisableInsightRulesResponse.wrap)
      .provideEnvironment(r)
    def setAlarmState(request: SetAlarmStateRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest,
        SetAlarmStateResponse
      ]("setAlarmState", api.setAlarmState)(request.buildAwsValue()).unit
        .provideEnvironment(r)
  }
  def deleteAnomalyDetector(request: DeleteAnomalyDetectorRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.DeleteAnomalyDetectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAnomalyDetector(request))
  def putMetricAlarm(
      request: PutMetricAlarmRequest
  ): ZIO[zio.aws.cloudwatch.CloudWatch, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putMetricAlarm(request))
  def listManagedInsightRules(request: ListManagedInsightRulesRequest): ZStream[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.ManagedRuleDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.listManagedInsightRules(request))
  def listManagedInsightRulesPaginated(
      request: ListManagedInsightRulesRequest
  ): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.ListManagedInsightRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listManagedInsightRulesPaginated(request))
  def listMetricStreams(request: ListMetricStreamsRequest): ZStream[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.MetricStreamEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listMetricStreams(request))
  def listMetricStreamsPaginated(request: ListMetricStreamsRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.ListMetricStreamsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMetricStreamsPaginated(request))
  def describeAlarmsForMetric(request: DescribeAlarmsForMetricRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAlarmsForMetric(request))
  def describeAlarms(request: DescribeAlarmsRequest): ZStream[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.MetricAlarm.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAlarms(request))
  def describeAlarmsPaginated(request: DescribeAlarmsRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.DescribeAlarmsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAlarmsPaginated(request))
  def putManagedInsightRules(request: PutManagedInsightRulesRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.PutManagedInsightRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putManagedInsightRules(request))
  def disableAlarmActions(
      request: DisableAlarmActionsRequest
  ): ZIO[zio.aws.cloudwatch.CloudWatch, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disableAlarmActions(request))
  def deleteInsightRules(request: DeleteInsightRulesRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.DeleteInsightRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInsightRules(request))
  def describeInsightRules(request: DescribeInsightRulesRequest): ZStream[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.InsightRule.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInsightRules(request))
  def describeInsightRulesPaginated(request: DescribeInsightRulesRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.DescribeInsightRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInsightRulesPaginated(request))
  def putDashboard(request: PutDashboardRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.PutDashboardResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putDashboard(request))
  def describeAlarmHistory(request: DescribeAlarmHistoryRequest): ZStream[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.AlarmHistoryItem.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAlarmHistory(request))
  def describeAlarmHistoryPaginated(request: DescribeAlarmHistoryRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.DescribeAlarmHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAlarmHistoryPaginated(request))
  def stopMetricStreams(request: StopMetricStreamsRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.StopMetricStreamsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopMetricStreams(request))
  def getMetricStream(request: GetMetricStreamRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.GetMetricStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMetricStream(request))
  def getMetricWidgetImage(request: GetMetricWidgetImageRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMetricWidgetImage(request))
  def getMetricData(request: GetMetricDataRequest): ZStream[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.MetricDataResult.ReadOnly
  ] = ZStream.serviceWithStream(_.getMetricData(request))
  def getMetricDataPaginated(request: GetMetricDataRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.GetMetricDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMetricDataPaginated(request))
  def getInsightRuleReport(request: GetInsightRuleReportRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInsightRuleReport(request))
  def getDashboard(request: GetDashboardRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.GetDashboardResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDashboard(request))
  def enableInsightRules(request: EnableInsightRulesRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.EnableInsightRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableInsightRules(request))
  def deleteMetricStream(request: DeleteMetricStreamRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.DeleteMetricStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMetricStream(request))
  def enableAlarmActions(
      request: EnableAlarmActionsRequest
  ): ZIO[zio.aws.cloudwatch.CloudWatch, AwsError, Unit] =
    ZIO.serviceWithZIO(_.enableAlarmActions(request))
  def listDashboards(request: ListDashboardsRequest): ZStream[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.DashboardEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listDashboards(request))
  def listDashboardsPaginated(request: ListDashboardsRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.ListDashboardsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDashboardsPaginated(request))
  def putMetricStream(request: PutMetricStreamRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.PutMetricStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putMetricStream(request))
  def deleteDashboards(request: DeleteDashboardsRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.DeleteDashboardsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDashboards(request))
  def putInsightRule(request: PutInsightRuleRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.PutInsightRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putInsightRule(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listMetrics(request: ListMetricsRequest): ZStream[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.Metric.ReadOnly
  ] = ZStream.serviceWithStream(_.listMetrics(request))
  def listMetricsPaginated(request: ListMetricsRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.ListMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMetricsPaginated(request))
  def putCompositeAlarm(
      request: PutCompositeAlarmRequest
  ): ZIO[zio.aws.cloudwatch.CloudWatch, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putCompositeAlarm(request))
  def putMetricData(
      request: PutMetricDataRequest
  ): ZIO[zio.aws.cloudwatch.CloudWatch, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putMetricData(request))
  def startMetricStreams(request: StartMetricStreamsRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.StartMetricStreamsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMetricStreams(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getMetricStatistics(request: GetMetricStatisticsRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMetricStatistics(request))
  def putAnomalyDetector(
      request: PutAnomalyDetectorRequest
  ): ZIO[zio.aws.cloudwatch.CloudWatch, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.putAnomalyDetector(request))
  def describeAnomalyDetectors(
      request: DescribeAnomalyDetectorsRequest
  ): ZStream[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.AnomalyDetector.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAnomalyDetectors(request))
  def describeAnomalyDetectorsPaginated(
      request: DescribeAnomalyDetectorsRequest
  ): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.DescribeAnomalyDetectorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAnomalyDetectorsPaginated(request))
  def deleteAlarms(
      request: DeleteAlarmsRequest
  ): ZIO[zio.aws.cloudwatch.CloudWatch, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAlarms(request))
  def disableInsightRules(request: DisableInsightRulesRequest): ZIO[
    zio.aws.cloudwatch.CloudWatch,
    AwsError,
    zio.aws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableInsightRules(request))
  def setAlarmState(
      request: SetAlarmStateRequest
  ): ZIO[zio.aws.cloudwatch.CloudWatch, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setAlarmState(request))
}
