package zio.aws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait ActionsSuppressedBy {
  def unwrap
      : software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy
}
object ActionsSuppressedBy {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy
  ): zio.aws.cloudwatch.model.ActionsSuppressedBy = value match {
    case software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy.WAIT_PERIOD =>
      val r = WaitPeriod
      r
    case software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy.EXTENSION_PERIOD =>
      val r = ExtensionPeriod
      r
    case software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy.ALARM =>
      val r = Alarm
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudwatch.model.ActionsSuppressedBy {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy =
      software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy.UNKNOWN_TO_SDK_VERSION
  }
  case object WaitPeriod extends zio.aws.cloudwatch.model.ActionsSuppressedBy {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy =
      software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy.WAIT_PERIOD
  }
  case object ExtensionPeriod
      extends zio.aws.cloudwatch.model.ActionsSuppressedBy {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy =
      software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy.EXTENSION_PERIOD
  }
  case object Alarm extends zio.aws.cloudwatch.model.ActionsSuppressedBy {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy =
      software.amazon.awssdk.services.cloudwatch.model.ActionsSuppressedBy.ALARM
  }
}
