package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.AnomalyDetectorMetricTimezone
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnomalyDetectorConfiguration(
    excludedTimeRanges: Optional[Iterable[zio.aws.cloudwatch.model.Range]] =
      Optional.Absent,
    metricTimezone: Optional[AnomalyDetectorMetricTimezone] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorConfiguration = {
    import AnomalyDetectorConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorConfiguration
      .builder()
      .optionallyWith(
        excludedTimeRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludedTimeRanges)
      .optionallyWith(
        metricTimezone.map(value =>
          AnomalyDetectorMetricTimezone.unwrap(value): java.lang.String
        )
      )(_.metricTimezone)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.AnomalyDetectorConfiguration.ReadOnly =
    zio.aws.cloudwatch.model.AnomalyDetectorConfiguration.wrap(buildAwsValue())
}
object AnomalyDetectorConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.AnomalyDetectorConfiguration =
      zio.aws.cloudwatch.model.AnomalyDetectorConfiguration(
        excludedTimeRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metricTimezone.map(value => value)
      )
    def excludedTimeRanges
        : Optional[List[zio.aws.cloudwatch.model.Range.ReadOnly]]
    def metricTimezone: Optional[AnomalyDetectorMetricTimezone]
    def getExcludedTimeRanges
        : ZIO[Any, AwsError, List[zio.aws.cloudwatch.model.Range.ReadOnly]] =
      AwsError.unwrapOptionField("excludedTimeRanges", excludedTimeRanges)
    def getMetricTimezone: ZIO[Any, AwsError, AnomalyDetectorMetricTimezone] =
      AwsError.unwrapOptionField("metricTimezone", metricTimezone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorConfiguration
  ) extends zio.aws.cloudwatch.model.AnomalyDetectorConfiguration.ReadOnly {
    override val excludedTimeRanges
        : Optional[List[zio.aws.cloudwatch.model.Range.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludedTimeRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Range.wrap(item)
          }.toList
        )
    override val metricTimezone: Optional[AnomalyDetectorMetricTimezone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricTimezone())
        .map(value =>
          zio.aws.cloudwatch.model.primitives
            .AnomalyDetectorMetricTimezone(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorConfiguration
  ): zio.aws.cloudwatch.model.AnomalyDetectorConfiguration.ReadOnly =
    new Wrapper(impl)
}
