package zio.aws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait AnomalyDetectorType {
  def unwrap
      : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType
}
object AnomalyDetectorType {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType
  ): zio.aws.cloudwatch.model.AnomalyDetectorType = value match {
    case software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType.SINGLE_METRIC =>
      val r = SINGLE_METRIC
      r
    case software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType.METRIC_MATH =>
      val r = METRIC_MATH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudwatch.model.AnomalyDetectorType {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType =
      software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType.UNKNOWN_TO_SDK_VERSION
  }
  case object SINGLE_METRIC
      extends zio.aws.cloudwatch.model.AnomalyDetectorType {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType =
      software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType.SINGLE_METRIC
  }
  case object METRIC_MATH extends zio.aws.cloudwatch.model.AnomalyDetectorType {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType =
      software.amazon.awssdk.services.cloudwatch.model.AnomalyDetectorType.METRIC_MATH
  }
}
