package zio.aws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait ComparisonOperator {
  def unwrap
      : software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator
}
object ComparisonOperator {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator
  ): zio.aws.cloudwatch.model.ComparisonOperator = value match {
    case software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD =>
      val r = GreaterThanOrEqualToThreshold
      r
    case software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.GREATER_THAN_THRESHOLD =>
      val r = GreaterThanThreshold
      r
    case software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.LESS_THAN_THRESHOLD =>
      val r = LessThanThreshold
      r
    case software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.LESS_THAN_OR_EQUAL_TO_THRESHOLD =>
      val r = LessThanOrEqualToThreshold
      r
    case software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.LESS_THAN_LOWER_OR_GREATER_THAN_UPPER_THRESHOLD =>
      val r = LessThanLowerOrGreaterThanUpperThreshold
      r
    case software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.LESS_THAN_LOWER_THRESHOLD =>
      val r = LessThanLowerThreshold
      r
    case software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.GREATER_THAN_UPPER_THRESHOLD =>
      val r = GreaterThanUpperThreshold
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudwatch.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator =
      software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object GreaterThanOrEqualToThreshold
      extends zio.aws.cloudwatch.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator =
      software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD
  }
  case object GreaterThanThreshold
      extends zio.aws.cloudwatch.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator =
      software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.GREATER_THAN_THRESHOLD
  }
  case object LessThanThreshold
      extends zio.aws.cloudwatch.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator =
      software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.LESS_THAN_THRESHOLD
  }
  case object LessThanOrEqualToThreshold
      extends zio.aws.cloudwatch.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator =
      software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.LESS_THAN_OR_EQUAL_TO_THRESHOLD
  }
  case object LessThanLowerOrGreaterThanUpperThreshold
      extends zio.aws.cloudwatch.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator =
      software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.LESS_THAN_LOWER_OR_GREATER_THAN_UPPER_THRESHOLD
  }
  case object LessThanLowerThreshold
      extends zio.aws.cloudwatch.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator =
      software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.LESS_THAN_LOWER_THRESHOLD
  }
  case object GreaterThanUpperThreshold
      extends zio.aws.cloudwatch.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator =
      software.amazon.awssdk.services.cloudwatch.model.ComparisonOperator.GREATER_THAN_UPPER_THRESHOLD
  }
}
