package zio.aws.cloudwatch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudwatch.model.primitives.{
  ExtendedStatistic,
  DatapointValue,
  Timestamp
}
import scala.jdk.CollectionConverters._
final case class Datapoint(
    timestamp: Optional[Timestamp] = Optional.Absent,
    sampleCount: Optional[DatapointValue] = Optional.Absent,
    average: Optional[DatapointValue] = Optional.Absent,
    sum: Optional[DatapointValue] = Optional.Absent,
    minimum: Optional[DatapointValue] = Optional.Absent,
    maximum: Optional[DatapointValue] = Optional.Absent,
    unit: Optional[zio.aws.cloudwatch.model.StandardUnit] = Optional.Absent,
    extendedStatistics: Optional[Map[ExtendedStatistic, DatapointValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.Datapoint = {
    import Datapoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.Datapoint
      .builder()
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(
        sampleCount.map(value => DatapointValue.unwrap(value): java.lang.Double)
      )(_.sampleCount)
      .optionallyWith(
        average.map(value => DatapointValue.unwrap(value): java.lang.Double)
      )(_.average)
      .optionallyWith(
        sum.map(value => DatapointValue.unwrap(value): java.lang.Double)
      )(_.sum)
      .optionallyWith(
        minimum.map(value => DatapointValue.unwrap(value): java.lang.Double)
      )(_.minimum)
      .optionallyWith(
        maximum.map(value => DatapointValue.unwrap(value): java.lang.Double)
      )(_.maximum)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        extendedStatistics.map(value =>
          value
            .map({ case (key, value) =>
              (ExtendedStatistic
                .unwrap(key): java.lang.String) -> (DatapointValue
                .unwrap(value): java.lang.Double)
            })
            .asJava
        )
      )(_.extendedStatistics)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.Datapoint.ReadOnly =
    zio.aws.cloudwatch.model.Datapoint.wrap(buildAwsValue())
}
object Datapoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.Datapoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.Datapoint =
      zio.aws.cloudwatch.model.Datapoint(
        timestamp.map(value => value),
        sampleCount.map(value => value),
        average.map(value => value),
        sum.map(value => value),
        minimum.map(value => value),
        maximum.map(value => value),
        unit.map(value => value),
        extendedStatistics.map(value => value)
      )
    def timestamp: Optional[Timestamp]
    def sampleCount: Optional[DatapointValue]
    def average: Optional[DatapointValue]
    def sum: Optional[DatapointValue]
    def minimum: Optional[DatapointValue]
    def maximum: Optional[DatapointValue]
    def unit: Optional[zio.aws.cloudwatch.model.StandardUnit]
    def extendedStatistics: Optional[Map[ExtendedStatistic, DatapointValue]]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getSampleCount: ZIO[Any, AwsError, DatapointValue] =
      AwsError.unwrapOptionField("sampleCount", sampleCount)
    def getAverage: ZIO[Any, AwsError, DatapointValue] =
      AwsError.unwrapOptionField("average", average)
    def getSum: ZIO[Any, AwsError, DatapointValue] =
      AwsError.unwrapOptionField("sum", sum)
    def getMinimum: ZIO[Any, AwsError, DatapointValue] =
      AwsError.unwrapOptionField("minimum", minimum)
    def getMaximum: ZIO[Any, AwsError, DatapointValue] =
      AwsError.unwrapOptionField("maximum", maximum)
    def getUnit: ZIO[Any, AwsError, zio.aws.cloudwatch.model.StandardUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getExtendedStatistics
        : ZIO[Any, AwsError, Map[ExtendedStatistic, DatapointValue]] =
      AwsError.unwrapOptionField("extendedStatistics", extendedStatistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.Datapoint
  ) extends zio.aws.cloudwatch.model.Datapoint.ReadOnly {
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
    override val sampleCount: Optional[DatapointValue] = zio.aws.core.internal
      .optionalFromNullable(impl.sampleCount())
      .map(value => zio.aws.cloudwatch.model.primitives.DatapointValue(value))
    override val average: Optional[DatapointValue] = zio.aws.core.internal
      .optionalFromNullable(impl.average())
      .map(value => zio.aws.cloudwatch.model.primitives.DatapointValue(value))
    override val sum: Optional[DatapointValue] = zio.aws.core.internal
      .optionalFromNullable(impl.sum())
      .map(value => zio.aws.cloudwatch.model.primitives.DatapointValue(value))
    override val minimum: Optional[DatapointValue] = zio.aws.core.internal
      .optionalFromNullable(impl.minimum())
      .map(value => zio.aws.cloudwatch.model.primitives.DatapointValue(value))
    override val maximum: Optional[DatapointValue] = zio.aws.core.internal
      .optionalFromNullable(impl.maximum())
      .map(value => zio.aws.cloudwatch.model.primitives.DatapointValue(value))
    override val unit: Optional[zio.aws.cloudwatch.model.StandardUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.cloudwatch.model.StandardUnit.wrap(value))
    override val extendedStatistics
        : Optional[Map[ExtendedStatistic, DatapointValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendedStatistics())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.cloudwatch.model.primitives.ExtendedStatistic(
                key
              ) -> zio.aws.cloudwatch.model.primitives.DatapointValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.Datapoint
  ): zio.aws.cloudwatch.model.Datapoint.ReadOnly = new Wrapper(impl)
}
