package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{
  AnomalyDetectorMetricStat,
  MetricName,
  Namespace
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteAnomalyDetectorRequest(
    namespace: Optional[Namespace] = Optional.Absent,
    metricName: Optional[MetricName] = Optional.Absent,
    dimensions: Optional[Iterable[zio.aws.cloudwatch.model.Dimension]] =
      Optional.Absent,
    stat: Optional[AnomalyDetectorMetricStat] = Optional.Absent,
    singleMetricAnomalyDetector: Optional[
      zio.aws.cloudwatch.model.SingleMetricAnomalyDetector
    ] = Optional.Absent,
    metricMathAnomalyDetector: Optional[
      zio.aws.cloudwatch.model.MetricMathAnomalyDetector
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorRequest = {
    import DeleteAnomalyDetectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorRequest
      .builder()
      .optionallyWith(
        namespace.map(value => Namespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(
        stat.map(value =>
          AnomalyDetectorMetricStat.unwrap(value): java.lang.String
        )
      )(_.stat)
      .optionallyWith(
        singleMetricAnomalyDetector.map(value => value.buildAwsValue())
      )(_.singleMetricAnomalyDetector)
      .optionallyWith(
        metricMathAnomalyDetector.map(value => value.buildAwsValue())
      )(_.metricMathAnomalyDetector)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.DeleteAnomalyDetectorRequest.ReadOnly =
    zio.aws.cloudwatch.model.DeleteAnomalyDetectorRequest.wrap(buildAwsValue())
}
object DeleteAnomalyDetectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DeleteAnomalyDetectorRequest =
      zio.aws.cloudwatch.model.DeleteAnomalyDetectorRequest(
        namespace.map(value => value),
        metricName.map(value => value),
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stat.map(value => value),
        singleMetricAnomalyDetector.map(value => value.asEditable),
        metricMathAnomalyDetector.map(value => value.asEditable)
      )
    def namespace: Optional[Namespace]
    def metricName: Optional[MetricName]
    def dimensions: Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]]
    def stat: Optional[AnomalyDetectorMetricStat]
    def singleMetricAnomalyDetector: Optional[
      zio.aws.cloudwatch.model.SingleMetricAnomalyDetector.ReadOnly
    ]
    def metricMathAnomalyDetector
        : Optional[zio.aws.cloudwatch.model.MetricMathAnomalyDetector.ReadOnly]
    def getNamespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getStat: ZIO[Any, AwsError, AnomalyDetectorMetricStat] =
      AwsError.unwrapOptionField("stat", stat)
    def getSingleMetricAnomalyDetector: ZIO[
      Any,
      AwsError,
      zio.aws.cloudwatch.model.SingleMetricAnomalyDetector.ReadOnly
    ] = AwsError.unwrapOptionField(
      "singleMetricAnomalyDetector",
      singleMetricAnomalyDetector
    )
    def getMetricMathAnomalyDetector: ZIO[
      Any,
      AwsError,
      zio.aws.cloudwatch.model.MetricMathAnomalyDetector.ReadOnly
    ] = AwsError.unwrapOptionField(
      "metricMathAnomalyDetector",
      metricMathAnomalyDetector
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorRequest
  ) extends zio.aws.cloudwatch.model.DeleteAnomalyDetectorRequest.ReadOnly {
    override val namespace: Optional[Namespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => zio.aws.cloudwatch.model.primitives.Namespace(value))
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricName(value))
    override val dimensions
        : Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Dimension.wrap(item)
          }.toList
        )
    override val stat: Optional[AnomalyDetectorMetricStat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stat())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.AnomalyDetectorMetricStat(value)
        )
    override val singleMetricAnomalyDetector: Optional[
      zio.aws.cloudwatch.model.SingleMetricAnomalyDetector.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.singleMetricAnomalyDetector())
      .map(value =>
        zio.aws.cloudwatch.model.SingleMetricAnomalyDetector.wrap(value)
      )
    override val metricMathAnomalyDetector: Optional[
      zio.aws.cloudwatch.model.MetricMathAnomalyDetector.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metricMathAnomalyDetector())
      .map(value =>
        zio.aws.cloudwatch.model.MetricMathAnomalyDetector.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorRequest
  ): zio.aws.cloudwatch.model.DeleteAnomalyDetectorRequest.ReadOnly =
    new Wrapper(impl)
}
