package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.InsightRuleName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteInsightRulesRequest(
    ruleNames: Iterable[InsightRuleName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest = {
    import DeleteInsightRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest
      .builder()
      .ruleNames(ruleNames.map { item =>
        InsightRuleName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.DeleteInsightRulesRequest.ReadOnly =
    zio.aws.cloudwatch.model.DeleteInsightRulesRequest.wrap(buildAwsValue())
}
object DeleteInsightRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DeleteInsightRulesRequest =
      zio.aws.cloudwatch.model.DeleteInsightRulesRequest(ruleNames)
    def ruleNames: List[InsightRuleName]
    def getRuleNames: ZIO[Any, Nothing, List[InsightRuleName]] =
      ZIO.succeed(ruleNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest
  ) extends zio.aws.cloudwatch.model.DeleteInsightRulesRequest.ReadOnly {
    override val ruleNames: List[InsightRuleName] = impl
      .ruleNames()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.primitives.InsightRuleName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest
  ): zio.aws.cloudwatch.model.DeleteInsightRulesRequest.ReadOnly = new Wrapper(
    impl
  )
}
