package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.MetricStreamName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMetricStreamRequest(name: MetricStreamName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamRequest = {
    import DeleteMetricStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamRequest
      .builder()
      .name(MetricStreamName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.DeleteMetricStreamRequest.ReadOnly =
    zio.aws.cloudwatch.model.DeleteMetricStreamRequest.wrap(buildAwsValue())
}
object DeleteMetricStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DeleteMetricStreamRequest =
      zio.aws.cloudwatch.model.DeleteMetricStreamRequest(name)
    def name: MetricStreamName
    def getName: ZIO[Any, Nothing, MetricStreamName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamRequest
  ) extends zio.aws.cloudwatch.model.DeleteMetricStreamRequest.ReadOnly {
    override val name: MetricStreamName =
      zio.aws.cloudwatch.model.primitives.MetricStreamName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamRequest
  ): zio.aws.cloudwatch.model.DeleteMetricStreamRequest.ReadOnly = new Wrapper(
    impl
  )
}
