package zio.aws.cloudwatch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  NextToken,
  AlarmNamePrefix,
  AlarmName,
  MaxRecords,
  ActionPrefix
}
import scala.jdk.CollectionConverters._
final case class DescribeAlarmsRequest(
    alarmNames: Optional[Iterable[AlarmName]] = Optional.Absent,
    alarmNamePrefix: Optional[AlarmNamePrefix] = Optional.Absent,
    alarmTypes: Optional[Iterable[zio.aws.cloudwatch.model.AlarmType]] =
      Optional.Absent,
    childrenOfAlarmName: Optional[AlarmName] = Optional.Absent,
    parentsOfAlarmName: Optional[AlarmName] = Optional.Absent,
    stateValue: Optional[zio.aws.cloudwatch.model.StateValue] = Optional.Absent,
    actionPrefix: Optional[ActionPrefix] = Optional.Absent,
    maxRecords: Optional[MaxRecords] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest = {
    import DescribeAlarmsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest
      .builder()
      .optionallyWith(
        alarmNames.map(value =>
          value.map { item =>
            AlarmName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.alarmNames)
      .optionallyWith(
        alarmNamePrefix.map(value =>
          AlarmNamePrefix.unwrap(value): java.lang.String
        )
      )(_.alarmNamePrefix)
      .optionallyWith(
        alarmTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.alarmTypesWithStrings)
      .optionallyWith(
        childrenOfAlarmName.map(value =>
          AlarmName.unwrap(value): java.lang.String
        )
      )(_.childrenOfAlarmName)
      .optionallyWith(
        parentsOfAlarmName.map(value =>
          AlarmName.unwrap(value): java.lang.String
        )
      )(_.parentsOfAlarmName)
      .optionallyWith(stateValue.map(value => value.unwrap))(_.stateValue)
      .optionallyWith(
        actionPrefix.map(value => ActionPrefix.unwrap(value): java.lang.String)
      )(_.actionPrefix)
      .optionallyWith(
        maxRecords.map(value => MaxRecords.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.DescribeAlarmsRequest.ReadOnly =
    zio.aws.cloudwatch.model.DescribeAlarmsRequest.wrap(buildAwsValue())
}
object DescribeAlarmsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DescribeAlarmsRequest =
      zio.aws.cloudwatch.model.DescribeAlarmsRequest(
        alarmNames.map(value => value),
        alarmNamePrefix.map(value => value),
        alarmTypes.map(value => value),
        childrenOfAlarmName.map(value => value),
        parentsOfAlarmName.map(value => value),
        stateValue.map(value => value),
        actionPrefix.map(value => value),
        maxRecords.map(value => value),
        nextToken.map(value => value)
      )
    def alarmNames: Optional[List[AlarmName]]
    def alarmNamePrefix: Optional[AlarmNamePrefix]
    def alarmTypes: Optional[List[zio.aws.cloudwatch.model.AlarmType]]
    def childrenOfAlarmName: Optional[AlarmName]
    def parentsOfAlarmName: Optional[AlarmName]
    def stateValue: Optional[zio.aws.cloudwatch.model.StateValue]
    def actionPrefix: Optional[ActionPrefix]
    def maxRecords: Optional[MaxRecords]
    def nextToken: Optional[NextToken]
    def getAlarmNames: ZIO[Any, AwsError, List[AlarmName]] =
      AwsError.unwrapOptionField("alarmNames", alarmNames)
    def getAlarmNamePrefix: ZIO[Any, AwsError, AlarmNamePrefix] =
      AwsError.unwrapOptionField("alarmNamePrefix", alarmNamePrefix)
    def getAlarmTypes
        : ZIO[Any, AwsError, List[zio.aws.cloudwatch.model.AlarmType]] =
      AwsError.unwrapOptionField("alarmTypes", alarmTypes)
    def getChildrenOfAlarmName: ZIO[Any, AwsError, AlarmName] =
      AwsError.unwrapOptionField("childrenOfAlarmName", childrenOfAlarmName)
    def getParentsOfAlarmName: ZIO[Any, AwsError, AlarmName] =
      AwsError.unwrapOptionField("parentsOfAlarmName", parentsOfAlarmName)
    def getStateValue: ZIO[Any, AwsError, zio.aws.cloudwatch.model.StateValue] =
      AwsError.unwrapOptionField("stateValue", stateValue)
    def getActionPrefix: ZIO[Any, AwsError, ActionPrefix] =
      AwsError.unwrapOptionField("actionPrefix", actionPrefix)
    def getMaxRecords: ZIO[Any, AwsError, MaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest
  ) extends zio.aws.cloudwatch.model.DescribeAlarmsRequest.ReadOnly {
    override val alarmNames: Optional[List[AlarmName]] = zio.aws.core.internal
      .optionalFromNullable(impl.alarmNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.primitives.AlarmName(item)
        }.toList
      )
    override val alarmNamePrefix: Optional[AlarmNamePrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmNamePrefix())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.AlarmNamePrefix(value)
        )
    override val alarmTypes
        : Optional[List[zio.aws.cloudwatch.model.AlarmType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.AlarmType.wrap(item)
          }.toList
        )
    override val childrenOfAlarmName: Optional[AlarmName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.childrenOfAlarmName())
        .map(value => zio.aws.cloudwatch.model.primitives.AlarmName(value))
    override val parentsOfAlarmName: Optional[AlarmName] = zio.aws.core.internal
      .optionalFromNullable(impl.parentsOfAlarmName())
      .map(value => zio.aws.cloudwatch.model.primitives.AlarmName(value))
    override val stateValue: Optional[zio.aws.cloudwatch.model.StateValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateValue())
        .map(value => zio.aws.cloudwatch.model.StateValue.wrap(value))
    override val actionPrefix: Optional[ActionPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.actionPrefix())
      .map(value => zio.aws.cloudwatch.model.primitives.ActionPrefix(value))
    override val maxRecords: Optional[MaxRecords] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => zio.aws.cloudwatch.model.primitives.MaxRecords(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest
  ): zio.aws.cloudwatch.model.DescribeAlarmsRequest.ReadOnly = new Wrapper(impl)
}
