package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAlarmsResponse(
    compositeAlarms: Optional[
      Iterable[zio.aws.cloudwatch.model.CompositeAlarm]
    ] = Optional.Absent,
    metricAlarms: Optional[Iterable[zio.aws.cloudwatch.model.MetricAlarm]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse = {
    import DescribeAlarmsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse
      .builder()
      .optionallyWith(
        compositeAlarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.compositeAlarms)
      .optionallyWith(
        metricAlarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricAlarms)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.DescribeAlarmsResponse.ReadOnly =
    zio.aws.cloudwatch.model.DescribeAlarmsResponse.wrap(buildAwsValue())
}
object DescribeAlarmsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DescribeAlarmsResponse =
      zio.aws.cloudwatch.model.DescribeAlarmsResponse(
        compositeAlarms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metricAlarms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def compositeAlarms
        : Optional[List[zio.aws.cloudwatch.model.CompositeAlarm.ReadOnly]]
    def metricAlarms
        : Optional[List[zio.aws.cloudwatch.model.MetricAlarm.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getCompositeAlarms: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.CompositeAlarm.ReadOnly
    ]] = AwsError.unwrapOptionField("compositeAlarms", compositeAlarms)
    def getMetricAlarms: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MetricAlarm.ReadOnly
    ]] = AwsError.unwrapOptionField("metricAlarms", metricAlarms)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse
  ) extends zio.aws.cloudwatch.model.DescribeAlarmsResponse.ReadOnly {
    override val compositeAlarms
        : Optional[List[zio.aws.cloudwatch.model.CompositeAlarm.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compositeAlarms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.CompositeAlarm.wrap(item)
          }.toList
        )
    override val metricAlarms
        : Optional[List[zio.aws.cloudwatch.model.MetricAlarm.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricAlarms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.MetricAlarm.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse
  ): zio.aws.cloudwatch.model.DescribeAlarmsResponse.ReadOnly = new Wrapper(
    impl
  )
}
