package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInsightRulesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    insightRules: Optional[Iterable[zio.aws.cloudwatch.model.InsightRule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse = {
    import DescribeInsightRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        insightRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.insightRules)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.DescribeInsightRulesResponse.ReadOnly =
    zio.aws.cloudwatch.model.DescribeInsightRulesResponse.wrap(buildAwsValue())
}
object DescribeInsightRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DescribeInsightRulesResponse =
      zio.aws.cloudwatch.model.DescribeInsightRulesResponse(
        nextToken.map(value => value),
        insightRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def insightRules
        : Optional[List[zio.aws.cloudwatch.model.InsightRule.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getInsightRules: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.InsightRule.ReadOnly
    ]] = AwsError.unwrapOptionField("insightRules", insightRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse
  ) extends zio.aws.cloudwatch.model.DescribeInsightRulesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
    override val insightRules
        : Optional[List[zio.aws.cloudwatch.model.InsightRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insightRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.InsightRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse
  ): zio.aws.cloudwatch.model.DescribeInsightRulesResponse.ReadOnly =
    new Wrapper(impl)
}
