package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{DimensionValue, DimensionName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Dimension(name: DimensionName, value: DimensionValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.Dimension = {
    import Dimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.Dimension
      .builder()
      .name(DimensionName.unwrap(name): java.lang.String)
      .value(DimensionValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.Dimension.ReadOnly =
    zio.aws.cloudwatch.model.Dimension.wrap(buildAwsValue())
}
object Dimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.Dimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.Dimension =
      zio.aws.cloudwatch.model.Dimension(name, value)
    def name: DimensionName
    def value: DimensionValue
    def getName: ZIO[Any, Nothing, DimensionName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, DimensionValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.Dimension
  ) extends zio.aws.cloudwatch.model.Dimension.ReadOnly {
    override val name: DimensionName =
      zio.aws.cloudwatch.model.primitives.DimensionName(impl.name())
    override val value: DimensionValue =
      zio.aws.cloudwatch.model.primitives.DimensionValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.Dimension
  ): zio.aws.cloudwatch.model.Dimension.ReadOnly = new Wrapper(impl)
}
