package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.AlarmName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableAlarmActionsRequest(alarmNames: Iterable[AlarmName]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest = {
    import DisableAlarmActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest
      .builder()
      .alarmNames(alarmNames.map { item =>
        AlarmName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.DisableAlarmActionsRequest.ReadOnly =
    zio.aws.cloudwatch.model.DisableAlarmActionsRequest.wrap(buildAwsValue())
}
object DisableAlarmActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DisableAlarmActionsRequest =
      zio.aws.cloudwatch.model.DisableAlarmActionsRequest(alarmNames)
    def alarmNames: List[AlarmName]
    def getAlarmNames: ZIO[Any, Nothing, List[AlarmName]] =
      ZIO.succeed(alarmNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest
  ) extends zio.aws.cloudwatch.model.DisableAlarmActionsRequest.ReadOnly {
    override val alarmNames: List[AlarmName] = impl
      .alarmNames()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.primitives.AlarmName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest
  ): zio.aws.cloudwatch.model.DisableAlarmActionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
