package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.InsightRuleName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableInsightRulesRequest(
    ruleNames: Iterable[InsightRuleName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest = {
    import DisableInsightRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest
      .builder()
      .ruleNames(ruleNames.map { item =>
        InsightRuleName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.DisableInsightRulesRequest.ReadOnly =
    zio.aws.cloudwatch.model.DisableInsightRulesRequest.wrap(buildAwsValue())
}
object DisableInsightRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.DisableInsightRulesRequest =
      zio.aws.cloudwatch.model.DisableInsightRulesRequest(ruleNames)
    def ruleNames: List[InsightRuleName]
    def getRuleNames: ZIO[Any, Nothing, List[InsightRuleName]] =
      ZIO.succeed(ruleNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest
  ) extends zio.aws.cloudwatch.model.DisableInsightRulesRequest.ReadOnly {
    override val ruleNames: List[InsightRuleName] = impl
      .ruleNames()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.primitives.InsightRuleName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest
  ): zio.aws.cloudwatch.model.DisableInsightRulesRequest.ReadOnly = new Wrapper(
    impl
  )
}
