package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.InsightRuleName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableInsightRulesRequest(
    ruleNames: Iterable[InsightRuleName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest = {
    import EnableInsightRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest
      .builder()
      .ruleNames(ruleNames.map { item =>
        InsightRuleName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.EnableInsightRulesRequest.ReadOnly =
    zio.aws.cloudwatch.model.EnableInsightRulesRequest.wrap(buildAwsValue())
}
object EnableInsightRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.EnableInsightRulesRequest =
      zio.aws.cloudwatch.model.EnableInsightRulesRequest(ruleNames)
    def ruleNames: List[InsightRuleName]
    def getRuleNames: ZIO[Any, Nothing, List[InsightRuleName]] =
      ZIO.succeed(ruleNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest
  ) extends zio.aws.cloudwatch.model.EnableInsightRulesRequest.ReadOnly {
    override val ruleNames: List[InsightRuleName] = impl
      .ruleNames()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.primitives.InsightRuleName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest
  ): zio.aws.cloudwatch.model.EnableInsightRulesRequest.ReadOnly = new Wrapper(
    impl
  )
}
