package zio.aws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait EvaluationState {
  def unwrap: software.amazon.awssdk.services.cloudwatch.model.EvaluationState
}
object EvaluationState {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.EvaluationState
  ): zio.aws.cloudwatch.model.EvaluationState = value match {
    case software.amazon.awssdk.services.cloudwatch.model.EvaluationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudwatch.model.EvaluationState.PARTIAL_DATA =>
      val r = PARTIAL_DATA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudwatch.model.EvaluationState {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.EvaluationState =
      software.amazon.awssdk.services.cloudwatch.model.EvaluationState.UNKNOWN_TO_SDK_VERSION
  }
  case object PARTIAL_DATA extends zio.aws.cloudwatch.model.EvaluationState {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.EvaluationState =
      software.amazon.awssdk.services.cloudwatch.model.EvaluationState.PARTIAL_DATA
  }
}
