package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.DashboardName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDashboardRequest(dashboardName: DashboardName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest = {
    import GetDashboardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest
      .builder()
      .dashboardName(DashboardName.unwrap(dashboardName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.GetDashboardRequest.ReadOnly =
    zio.aws.cloudwatch.model.GetDashboardRequest.wrap(buildAwsValue())
}
object GetDashboardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.GetDashboardRequest =
      zio.aws.cloudwatch.model.GetDashboardRequest(dashboardName)
    def dashboardName: DashboardName
    def getDashboardName: ZIO[Any, Nothing, DashboardName] =
      ZIO.succeed(dashboardName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest
  ) extends zio.aws.cloudwatch.model.GetDashboardRequest.ReadOnly {
    override val dashboardName: DashboardName =
      zio.aws.cloudwatch.model.primitives.DashboardName(impl.dashboardName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest
  ): zio.aws.cloudwatch.model.GetDashboardRequest.ReadOnly = new Wrapper(impl)
}
