package zio.aws.cloudwatch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  Timestamp,
  InsightRuleUnboundInteger,
  InsightRuleOrderBy,
  Period,
  InsightRuleMetricName,
  InsightRuleName
}
import scala.jdk.CollectionConverters._
final case class GetInsightRuleReportRequest(
    ruleName: InsightRuleName,
    startTime: Timestamp,
    endTime: Timestamp,
    period: Period,
    maxContributorCount: Optional[InsightRuleUnboundInteger] = Optional.Absent,
    metrics: Optional[Iterable[InsightRuleMetricName]] = Optional.Absent,
    orderBy: Optional[InsightRuleOrderBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest = {
    import GetInsightRuleReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest
      .builder()
      .ruleName(InsightRuleName.unwrap(ruleName): java.lang.String)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .period(Period.unwrap(period): Integer)
      .optionallyWith(
        maxContributorCount.map(value =>
          InsightRuleUnboundInteger.unwrap(value): Integer
        )
      )(_.maxContributorCount)
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            InsightRuleMetricName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(
        orderBy.map(value => InsightRuleOrderBy.unwrap(value): java.lang.String)
      )(_.orderBy)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.GetInsightRuleReportRequest.ReadOnly =
    zio.aws.cloudwatch.model.GetInsightRuleReportRequest.wrap(buildAwsValue())
}
object GetInsightRuleReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.GetInsightRuleReportRequest =
      zio.aws.cloudwatch.model.GetInsightRuleReportRequest(
        ruleName,
        startTime,
        endTime,
        period,
        maxContributorCount.map(value => value),
        metrics.map(value => value),
        orderBy.map(value => value)
      )
    def ruleName: InsightRuleName
    def startTime: Timestamp
    def endTime: Timestamp
    def period: Period
    def maxContributorCount: Optional[InsightRuleUnboundInteger]
    def metrics: Optional[List[InsightRuleMetricName]]
    def orderBy: Optional[InsightRuleOrderBy]
    def getRuleName: ZIO[Any, Nothing, InsightRuleName] = ZIO.succeed(ruleName)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getPeriod: ZIO[Any, Nothing, Period] = ZIO.succeed(period)
    def getMaxContributorCount: ZIO[Any, AwsError, InsightRuleUnboundInteger] =
      AwsError.unwrapOptionField("maxContributorCount", maxContributorCount)
    def getMetrics: ZIO[Any, AwsError, List[InsightRuleMetricName]] =
      AwsError.unwrapOptionField("metrics", metrics)
    def getOrderBy: ZIO[Any, AwsError, InsightRuleOrderBy] =
      AwsError.unwrapOptionField("orderBy", orderBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest
  ) extends zio.aws.cloudwatch.model.GetInsightRuleReportRequest.ReadOnly {
    override val ruleName: InsightRuleName =
      zio.aws.cloudwatch.model.primitives.InsightRuleName(impl.ruleName())
    override val startTime: Timestamp =
      zio.aws.cloudwatch.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.cloudwatch.model.primitives.Timestamp(impl.endTime())
    override val period: Period =
      zio.aws.cloudwatch.model.primitives.Period(impl.period())
    override val maxContributorCount: Optional[InsightRuleUnboundInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxContributorCount())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.InsightRuleUnboundInteger(value)
        )
    override val metrics: Optional[List[InsightRuleMetricName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.primitives.InsightRuleMetricName(item)
          }.toList
        )
    override val orderBy: Optional[InsightRuleOrderBy] = zio.aws.core.internal
      .optionalFromNullable(impl.orderBy())
      .map(value =>
        zio.aws.cloudwatch.model.primitives.InsightRuleOrderBy(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest
  ): zio.aws.cloudwatch.model.GetInsightRuleReportRequest.ReadOnly =
    new Wrapper(impl)
}
