package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMetricDataResponse(
    metricDataResults: Optional[
      Iterable[zio.aws.cloudwatch.model.MetricDataResult]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    messages: Optional[Iterable[zio.aws.cloudwatch.model.MessageData]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse = {
    import GetMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse
      .builder()
      .optionallyWith(
        metricDataResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricDataResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        messages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.messages)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.GetMetricDataResponse.ReadOnly =
    zio.aws.cloudwatch.model.GetMetricDataResponse.wrap(buildAwsValue())
}
object GetMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.GetMetricDataResponse =
      zio.aws.cloudwatch.model.GetMetricDataResponse(
        metricDataResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        messages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricDataResults
        : Optional[List[zio.aws.cloudwatch.model.MetricDataResult.ReadOnly]]
    def nextToken: Optional[NextToken]
    def messages: Optional[List[zio.aws.cloudwatch.model.MessageData.ReadOnly]]
    def getMetricDataResults: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MetricDataResult.ReadOnly
    ]] = AwsError.unwrapOptionField("metricDataResults", metricDataResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMessages: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MessageData.ReadOnly
    ]] = AwsError.unwrapOptionField("messages", messages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse
  ) extends zio.aws.cloudwatch.model.GetMetricDataResponse.ReadOnly {
    override val metricDataResults
        : Optional[List[zio.aws.cloudwatch.model.MetricDataResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricDataResults())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.MetricDataResult.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
    override val messages
        : Optional[List[zio.aws.cloudwatch.model.MessageData.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.MessageData.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse
  ): zio.aws.cloudwatch.model.GetMetricDataResponse.ReadOnly = new Wrapper(impl)
}
