package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.MetricLabel
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMetricStatisticsResponse(
    label: Optional[MetricLabel] = Optional.Absent,
    datapoints: Optional[Iterable[zio.aws.cloudwatch.model.Datapoint]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse = {
    import GetMetricStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse
      .builder()
      .optionallyWith(
        label.map(value => MetricLabel.unwrap(value): java.lang.String)
      )(_.label)
      .optionallyWith(
        datapoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datapoints)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly =
    zio.aws.cloudwatch.model.GetMetricStatisticsResponse.wrap(buildAwsValue())
}
object GetMetricStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.GetMetricStatisticsResponse =
      zio.aws.cloudwatch.model.GetMetricStatisticsResponse(
        label.map(value => value),
        datapoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def label: Optional[MetricLabel]
    def datapoints: Optional[List[zio.aws.cloudwatch.model.Datapoint.ReadOnly]]
    def getLabel: ZIO[Any, AwsError, MetricLabel] =
      AwsError.unwrapOptionField("label", label)
    def getDatapoints: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.Datapoint.ReadOnly
    ]] = AwsError.unwrapOptionField("datapoints", datapoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse
  ) extends zio.aws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly {
    override val label: Optional[MetricLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricLabel(value))
    override val datapoints
        : Optional[List[zio.aws.cloudwatch.model.Datapoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datapoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Datapoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse
  ): zio.aws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly =
    new Wrapper(impl)
}
