package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.MetricStreamName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMetricStreamRequest(name: MetricStreamName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamRequest = {
    import GetMetricStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamRequest
      .builder()
      .name(MetricStreamName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.GetMetricStreamRequest.ReadOnly =
    zio.aws.cloudwatch.model.GetMetricStreamRequest.wrap(buildAwsValue())
}
object GetMetricStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.GetMetricStreamRequest =
      zio.aws.cloudwatch.model.GetMetricStreamRequest(name)
    def name: MetricStreamName
    def getName: ZIO[Any, Nothing, MetricStreamName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamRequest
  ) extends zio.aws.cloudwatch.model.GetMetricStreamRequest.ReadOnly {
    override val name: MetricStreamName =
      zio.aws.cloudwatch.model.primitives.MetricStreamName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamRequest
  ): zio.aws.cloudwatch.model.GetMetricStreamRequest.ReadOnly = new Wrapper(
    impl
  )
}
