package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{OutputFormat, MetricWidget}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMetricWidgetImageRequest(
    metricWidget: MetricWidget,
    outputFormat: Optional[OutputFormat] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest = {
    import GetMetricWidgetImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest
      .builder()
      .metricWidget(MetricWidget.unwrap(metricWidget): java.lang.String)
      .optionallyWith(
        outputFormat.map(value => OutputFormat.unwrap(value): java.lang.String)
      )(_.outputFormat)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.GetMetricWidgetImageRequest.ReadOnly =
    zio.aws.cloudwatch.model.GetMetricWidgetImageRequest.wrap(buildAwsValue())
}
object GetMetricWidgetImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.GetMetricWidgetImageRequest =
      zio.aws.cloudwatch.model.GetMetricWidgetImageRequest(
        metricWidget,
        outputFormat.map(value => value)
      )
    def metricWidget: MetricWidget
    def outputFormat: Optional[OutputFormat]
    def getMetricWidget: ZIO[Any, Nothing, MetricWidget] =
      ZIO.succeed(metricWidget)
    def getOutputFormat: ZIO[Any, AwsError, OutputFormat] =
      AwsError.unwrapOptionField("outputFormat", outputFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest
  ) extends zio.aws.cloudwatch.model.GetMetricWidgetImageRequest.ReadOnly {
    override val metricWidget: MetricWidget =
      zio.aws.cloudwatch.model.primitives.MetricWidget(impl.metricWidget())
    override val outputFormat: Optional[OutputFormat] = zio.aws.core.internal
      .optionalFromNullable(impl.outputFormat())
      .map(value => zio.aws.cloudwatch.model.primitives.OutputFormat(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest
  ): zio.aws.cloudwatch.model.GetMetricWidgetImageRequest.ReadOnly =
    new Wrapper(impl)
}
