package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.MetricWidgetImage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMetricWidgetImageResponse(
    metricWidgetImage: Optional[MetricWidgetImage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageResponse = {
    import GetMetricWidgetImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageResponse
      .builder()
      .optionallyWith(
        metricWidgetImage.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.metricWidgetImage)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly =
    zio.aws.cloudwatch.model.GetMetricWidgetImageResponse.wrap(buildAwsValue())
}
object GetMetricWidgetImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.GetMetricWidgetImageResponse =
      zio.aws.cloudwatch.model
        .GetMetricWidgetImageResponse(metricWidgetImage.map(value => value))
    def metricWidgetImage: Optional[MetricWidgetImage]
    def getMetricWidgetImage: ZIO[Any, AwsError, MetricWidgetImage] =
      AwsError.unwrapOptionField("metricWidgetImage", metricWidgetImage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageResponse
  ) extends zio.aws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly {
    override val metricWidgetImage: Optional[MetricWidgetImage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricWidgetImage())
        .map(value =>
          zio.aws.cloudwatch.model.primitives
            .MetricWidgetImage(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageResponse
  ): zio.aws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly =
    new Wrapper(impl)
}
