package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{
  InsightRuleState,
  InsightRuleSchema,
  InsightRuleIsManaged,
  InsightRuleDefinition,
  InsightRuleName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InsightRule(
    name: InsightRuleName,
    state: InsightRuleState,
    schema: InsightRuleSchema,
    definition: InsightRuleDefinition,
    managedRule: Optional[InsightRuleIsManaged] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.InsightRule = {
    import InsightRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.InsightRule
      .builder()
      .name(InsightRuleName.unwrap(name): java.lang.String)
      .state(InsightRuleState.unwrap(state): java.lang.String)
      .schema(InsightRuleSchema.unwrap(schema): java.lang.String)
      .definition(InsightRuleDefinition.unwrap(definition): java.lang.String)
      .optionallyWith(
        managedRule.map(value =>
          InsightRuleIsManaged.unwrap(value): java.lang.Boolean
        )
      )(_.managedRule)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.InsightRule.ReadOnly =
    zio.aws.cloudwatch.model.InsightRule.wrap(buildAwsValue())
}
object InsightRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.InsightRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.InsightRule =
      zio.aws.cloudwatch.model.InsightRule(
        name,
        state,
        schema,
        definition,
        managedRule.map(value => value)
      )
    def name: InsightRuleName
    def state: InsightRuleState
    def schema: InsightRuleSchema
    def definition: InsightRuleDefinition
    def managedRule: Optional[InsightRuleIsManaged]
    def getName: ZIO[Any, Nothing, InsightRuleName] = ZIO.succeed(name)
    def getState: ZIO[Any, Nothing, InsightRuleState] = ZIO.succeed(state)
    def getSchema: ZIO[Any, Nothing, InsightRuleSchema] = ZIO.succeed(schema)
    def getDefinition: ZIO[Any, Nothing, InsightRuleDefinition] =
      ZIO.succeed(definition)
    def getManagedRule: ZIO[Any, AwsError, InsightRuleIsManaged] =
      AwsError.unwrapOptionField("managedRule", managedRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRule
  ) extends zio.aws.cloudwatch.model.InsightRule.ReadOnly {
    override val name: InsightRuleName =
      zio.aws.cloudwatch.model.primitives.InsightRuleName(impl.name())
    override val state: InsightRuleState =
      zio.aws.cloudwatch.model.primitives.InsightRuleState(impl.state())
    override val schema: InsightRuleSchema =
      zio.aws.cloudwatch.model.primitives.InsightRuleSchema(impl.schema())
    override val definition: InsightRuleDefinition =
      zio.aws.cloudwatch.model.primitives
        .InsightRuleDefinition(impl.definition())
    override val managedRule: Optional[InsightRuleIsManaged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedRule())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.InsightRuleIsManaged(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRule
  ): zio.aws.cloudwatch.model.InsightRule.ReadOnly = new Wrapper(impl)
}
