package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{
  InsightRuleUnboundDouble,
  InsightRuleContributorKey
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InsightRuleContributor(
    keys: Iterable[InsightRuleContributorKey],
    approximateAggregateValue: InsightRuleUnboundDouble,
    datapoints: Iterable[
      zio.aws.cloudwatch.model.InsightRuleContributorDatapoint
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributor = {
    import InsightRuleContributor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributor
      .builder()
      .keys(keys.map { item =>
        InsightRuleContributorKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .approximateAggregateValue(
        InsightRuleUnboundDouble.unwrap(
          approximateAggregateValue
        ): java.lang.Double
      )
      .datapoints(datapoints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.InsightRuleContributor.ReadOnly =
    zio.aws.cloudwatch.model.InsightRuleContributor.wrap(buildAwsValue())
}
object InsightRuleContributor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.InsightRuleContributor =
      zio.aws.cloudwatch.model.InsightRuleContributor(
        keys,
        approximateAggregateValue,
        datapoints.map { item =>
          item.asEditable
        }
      )
    def keys: List[InsightRuleContributorKey]
    def approximateAggregateValue: InsightRuleUnboundDouble
    def datapoints: List[
      zio.aws.cloudwatch.model.InsightRuleContributorDatapoint.ReadOnly
    ]
    def getKeys: ZIO[Any, Nothing, List[InsightRuleContributorKey]] =
      ZIO.succeed(keys)
    def getApproximateAggregateValue
        : ZIO[Any, Nothing, InsightRuleUnboundDouble] =
      ZIO.succeed(approximateAggregateValue)
    def getDatapoints: ZIO[Any, Nothing, List[
      zio.aws.cloudwatch.model.InsightRuleContributorDatapoint.ReadOnly
    ]] = ZIO.succeed(datapoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributor
  ) extends zio.aws.cloudwatch.model.InsightRuleContributor.ReadOnly {
    override val keys: List[InsightRuleContributorKey] = impl
      .keys()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.primitives.InsightRuleContributorKey(item)
      }
      .toList
    override val approximateAggregateValue: InsightRuleUnboundDouble =
      zio.aws.cloudwatch.model.primitives
        .InsightRuleUnboundDouble(impl.approximateAggregateValue())
    override val datapoints: List[
      zio.aws.cloudwatch.model.InsightRuleContributorDatapoint.ReadOnly
    ] = impl
      .datapoints()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.InsightRuleContributorDatapoint.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributor
  ): zio.aws.cloudwatch.model.InsightRuleContributor.ReadOnly = new Wrapper(
    impl
  )
}
