package zio.aws.cloudwatch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudwatch.model.primitives.{InsightRuleUnboundDouble, Timestamp}
import scala.jdk.CollectionConverters._
final case class InsightRuleMetricDatapoint(
    timestamp: Timestamp,
    uniqueContributors: Optional[InsightRuleUnboundDouble] = Optional.Absent,
    maxContributorValue: Optional[InsightRuleUnboundDouble] = Optional.Absent,
    sampleCount: Optional[InsightRuleUnboundDouble] = Optional.Absent,
    average: Optional[InsightRuleUnboundDouble] = Optional.Absent,
    sum: Optional[InsightRuleUnboundDouble] = Optional.Absent,
    minimum: Optional[InsightRuleUnboundDouble] = Optional.Absent,
    maximum: Optional[InsightRuleUnboundDouble] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.InsightRuleMetricDatapoint = {
    import InsightRuleMetricDatapoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.InsightRuleMetricDatapoint
      .builder()
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .optionallyWith(
        uniqueContributors.map(value =>
          InsightRuleUnboundDouble.unwrap(value): java.lang.Double
        )
      )(_.uniqueContributors)
      .optionallyWith(
        maxContributorValue.map(value =>
          InsightRuleUnboundDouble.unwrap(value): java.lang.Double
        )
      )(_.maxContributorValue)
      .optionallyWith(
        sampleCount.map(value =>
          InsightRuleUnboundDouble.unwrap(value): java.lang.Double
        )
      )(_.sampleCount)
      .optionallyWith(
        average.map(value =>
          InsightRuleUnboundDouble.unwrap(value): java.lang.Double
        )
      )(_.average)
      .optionallyWith(
        sum.map(value =>
          InsightRuleUnboundDouble.unwrap(value): java.lang.Double
        )
      )(_.sum)
      .optionallyWith(
        minimum.map(value =>
          InsightRuleUnboundDouble.unwrap(value): java.lang.Double
        )
      )(_.minimum)
      .optionallyWith(
        maximum.map(value =>
          InsightRuleUnboundDouble.unwrap(value): java.lang.Double
        )
      )(_.maximum)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.InsightRuleMetricDatapoint.ReadOnly =
    zio.aws.cloudwatch.model.InsightRuleMetricDatapoint.wrap(buildAwsValue())
}
object InsightRuleMetricDatapoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.InsightRuleMetricDatapoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.InsightRuleMetricDatapoint =
      zio.aws.cloudwatch.model.InsightRuleMetricDatapoint(
        timestamp,
        uniqueContributors.map(value => value),
        maxContributorValue.map(value => value),
        sampleCount.map(value => value),
        average.map(value => value),
        sum.map(value => value),
        minimum.map(value => value),
        maximum.map(value => value)
      )
    def timestamp: Timestamp
    def uniqueContributors: Optional[InsightRuleUnboundDouble]
    def maxContributorValue: Optional[InsightRuleUnboundDouble]
    def sampleCount: Optional[InsightRuleUnboundDouble]
    def average: Optional[InsightRuleUnboundDouble]
    def sum: Optional[InsightRuleUnboundDouble]
    def minimum: Optional[InsightRuleUnboundDouble]
    def maximum: Optional[InsightRuleUnboundDouble]
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getUniqueContributors: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("uniqueContributors", uniqueContributors)
    def getMaxContributorValue: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("maxContributorValue", maxContributorValue)
    def getSampleCount: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("sampleCount", sampleCount)
    def getAverage: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("average", average)
    def getSum: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("sum", sum)
    def getMinimum: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("minimum", minimum)
    def getMaximum: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("maximum", maximum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRuleMetricDatapoint
  ) extends zio.aws.cloudwatch.model.InsightRuleMetricDatapoint.ReadOnly {
    override val timestamp: Timestamp =
      zio.aws.cloudwatch.model.primitives.Timestamp(impl.timestamp())
    override val uniqueContributors: Optional[InsightRuleUnboundDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uniqueContributors())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.InsightRuleUnboundDouble(value)
        )
    override val maxContributorValue: Optional[InsightRuleUnboundDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxContributorValue())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.InsightRuleUnboundDouble(value)
        )
    override val sampleCount: Optional[InsightRuleUnboundDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sampleCount())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.InsightRuleUnboundDouble(value)
        )
    override val average: Optional[InsightRuleUnboundDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.average())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.InsightRuleUnboundDouble(value)
        )
    override val sum: Optional[InsightRuleUnboundDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.sum())
      .map(value =>
        zio.aws.cloudwatch.model.primitives.InsightRuleUnboundDouble(value)
      )
    override val minimum: Optional[InsightRuleUnboundDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimum())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.InsightRuleUnboundDouble(value)
        )
    override val maximum: Optional[InsightRuleUnboundDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximum())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.InsightRuleUnboundDouble(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRuleMetricDatapoint
  ): zio.aws.cloudwatch.model.InsightRuleMetricDatapoint.ReadOnly = new Wrapper(
    impl
  )
}
