package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDashboardsResponse(
    dashboardEntries: Optional[
      Iterable[zio.aws.cloudwatch.model.DashboardEntry]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse = {
    import ListDashboardsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse
      .builder()
      .optionallyWith(
        dashboardEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dashboardEntries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.ListDashboardsResponse.ReadOnly =
    zio.aws.cloudwatch.model.ListDashboardsResponse.wrap(buildAwsValue())
}
object ListDashboardsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.ListDashboardsResponse =
      zio.aws.cloudwatch.model.ListDashboardsResponse(
        dashboardEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dashboardEntries
        : Optional[List[zio.aws.cloudwatch.model.DashboardEntry.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDashboardEntries: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.DashboardEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("dashboardEntries", dashboardEntries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse
  ) extends zio.aws.cloudwatch.model.ListDashboardsResponse.ReadOnly {
    override val dashboardEntries
        : Optional[List[zio.aws.cloudwatch.model.DashboardEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dashboardEntries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.DashboardEntry.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse
  ): zio.aws.cloudwatch.model.ListDashboardsResponse.ReadOnly = new Wrapper(
    impl
  )
}
