package zio.aws.cloudwatch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  InsightRuleMaxResults,
  NextToken,
  AmazonResourceName
}
import scala.jdk.CollectionConverters._
final case class ListManagedInsightRulesRequest(
    resourceARN: AmazonResourceName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[InsightRuleMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest = {
    import ListManagedInsightRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => InsightRuleMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.ListManagedInsightRulesRequest.ReadOnly =
    zio.aws.cloudwatch.model.ListManagedInsightRulesRequest
      .wrap(buildAwsValue())
}
object ListManagedInsightRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.ListManagedInsightRulesRequest =
      zio.aws.cloudwatch.model.ListManagedInsightRulesRequest(
        resourceARN,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceARN: AmazonResourceName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[InsightRuleMaxResults]
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, InsightRuleMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest
  ) extends zio.aws.cloudwatch.model.ListManagedInsightRulesRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.cloudwatch.model.primitives.AmazonResourceName(impl.resourceARN())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
    override val maxResults: Optional[InsightRuleMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.InsightRuleMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest
  ): zio.aws.cloudwatch.model.ListManagedInsightRulesRequest.ReadOnly =
    new Wrapper(impl)
}
