package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListManagedInsightRulesResponse(
    managedRules: Optional[
      Iterable[zio.aws.cloudwatch.model.ManagedRuleDescription]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesResponse = {
    import ListManagedInsightRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesResponse
      .builder()
      .optionallyWith(
        managedRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedRules)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.ListManagedInsightRulesResponse.ReadOnly =
    zio.aws.cloudwatch.model.ListManagedInsightRulesResponse
      .wrap(buildAwsValue())
}
object ListManagedInsightRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.ListManagedInsightRulesResponse =
      zio.aws.cloudwatch.model.ListManagedInsightRulesResponse(
        managedRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def managedRules: Optional[
      List[zio.aws.cloudwatch.model.ManagedRuleDescription.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getManagedRules: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.ManagedRuleDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("managedRules", managedRules)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesResponse
  ) extends zio.aws.cloudwatch.model.ListManagedInsightRulesResponse.ReadOnly {
    override val managedRules: Optional[
      List[zio.aws.cloudwatch.model.ManagedRuleDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.managedRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.ManagedRuleDescription.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesResponse
  ): zio.aws.cloudwatch.model.ListManagedInsightRulesResponse.ReadOnly =
    new Wrapper(impl)
}
