package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMetricStreamsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    entries: Optional[Iterable[zio.aws.cloudwatch.model.MetricStreamEntry]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsResponse = {
    import ListMetricStreamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        entries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entries)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.ListMetricStreamsResponse.ReadOnly =
    zio.aws.cloudwatch.model.ListMetricStreamsResponse.wrap(buildAwsValue())
}
object ListMetricStreamsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.ListMetricStreamsResponse =
      zio.aws.cloudwatch.model.ListMetricStreamsResponse(
        nextToken.map(value => value),
        entries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def entries
        : Optional[List[zio.aws.cloudwatch.model.MetricStreamEntry.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getEntries: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MetricStreamEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("entries", entries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsResponse
  ) extends zio.aws.cloudwatch.model.ListMetricStreamsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
    override val entries
        : Optional[List[zio.aws.cloudwatch.model.MetricStreamEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.MetricStreamEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsResponse
  ): zio.aws.cloudwatch.model.ListMetricStreamsResponse.ReadOnly = new Wrapper(
    impl
  )
}
