package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{AmazonResourceName, TemplateName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ManagedRule(
    templateName: TemplateName,
    resourceARN: AmazonResourceName,
    tags: Optional[Iterable[zio.aws.cloudwatch.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ManagedRule = {
    import ManagedRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ManagedRule
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.ManagedRule.ReadOnly =
    zio.aws.cloudwatch.model.ManagedRule.wrap(buildAwsValue())
}
object ManagedRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ManagedRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.ManagedRule =
      zio.aws.cloudwatch.model.ManagedRule(
        templateName,
        resourceARN,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def templateName: TemplateName
    def resourceARN: AmazonResourceName
    def tags: Optional[List[zio.aws.cloudwatch.model.Tag.ReadOnly]]
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudwatch.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ManagedRule
  ) extends zio.aws.cloudwatch.model.ManagedRule.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.cloudwatch.model.primitives.TemplateName(impl.templateName())
    override val resourceARN: AmazonResourceName =
      zio.aws.cloudwatch.model.primitives.AmazonResourceName(impl.resourceARN())
    override val tags: Optional[List[zio.aws.cloudwatch.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ManagedRule
  ): zio.aws.cloudwatch.model.ManagedRule.ReadOnly = new Wrapper(impl)
}
