package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{AmazonResourceName, TemplateName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ManagedRuleDescription(
    templateName: Optional[TemplateName] = Optional.Absent,
    resourceARN: Optional[AmazonResourceName] = Optional.Absent,
    ruleState: Optional[zio.aws.cloudwatch.model.ManagedRuleState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ManagedRuleDescription = {
    import ManagedRuleDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ManagedRuleDescription
      .builder()
      .optionallyWith(
        templateName.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.templateName)
      .optionallyWith(
        resourceARN.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.resourceARN)
      .optionallyWith(ruleState.map(value => value.buildAwsValue()))(
        _.ruleState
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.ManagedRuleDescription.ReadOnly =
    zio.aws.cloudwatch.model.ManagedRuleDescription.wrap(buildAwsValue())
}
object ManagedRuleDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ManagedRuleDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.ManagedRuleDescription =
      zio.aws.cloudwatch.model.ManagedRuleDescription(
        templateName.map(value => value),
        resourceARN.map(value => value),
        ruleState.map(value => value.asEditable)
      )
    def templateName: Optional[TemplateName]
    def resourceARN: Optional[AmazonResourceName]
    def ruleState: Optional[zio.aws.cloudwatch.model.ManagedRuleState.ReadOnly]
    def getTemplateName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getResourceARN: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getRuleState: ZIO[
      Any,
      AwsError,
      zio.aws.cloudwatch.model.ManagedRuleState.ReadOnly
    ] = AwsError.unwrapOptionField("ruleState", ruleState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ManagedRuleDescription
  ) extends zio.aws.cloudwatch.model.ManagedRuleDescription.ReadOnly {
    override val templateName: Optional[TemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.templateName())
      .map(value => zio.aws.cloudwatch.model.primitives.TemplateName(value))
    override val resourceARN: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceARN())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.AmazonResourceName(value)
        )
    override val ruleState
        : Optional[zio.aws.cloudwatch.model.ManagedRuleState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleState())
        .map(value => zio.aws.cloudwatch.model.ManagedRuleState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ManagedRuleDescription
  ): zio.aws.cloudwatch.model.ManagedRuleDescription.ReadOnly = new Wrapper(
    impl
  )
}
