package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{InsightRuleState, InsightRuleName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ManagedRuleState(
    ruleName: InsightRuleName,
    state: InsightRuleState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ManagedRuleState = {
    import ManagedRuleState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ManagedRuleState
      .builder()
      .ruleName(InsightRuleName.unwrap(ruleName): java.lang.String)
      .state(InsightRuleState.unwrap(state): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.ManagedRuleState.ReadOnly =
    zio.aws.cloudwatch.model.ManagedRuleState.wrap(buildAwsValue())
}
object ManagedRuleState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ManagedRuleState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.ManagedRuleState =
      zio.aws.cloudwatch.model.ManagedRuleState(ruleName, state)
    def ruleName: InsightRuleName
    def state: InsightRuleState
    def getRuleName: ZIO[Any, Nothing, InsightRuleName] = ZIO.succeed(ruleName)
    def getState: ZIO[Any, Nothing, InsightRuleState] = ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ManagedRuleState
  ) extends zio.aws.cloudwatch.model.ManagedRuleState.ReadOnly {
    override val ruleName: InsightRuleName =
      zio.aws.cloudwatch.model.primitives.InsightRuleName(impl.ruleName())
    override val state: InsightRuleState =
      zio.aws.cloudwatch.model.primitives.InsightRuleState(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ManagedRuleState
  ): zio.aws.cloudwatch.model.ManagedRuleState.ReadOnly = new Wrapper(impl)
}
