package zio.aws.cloudwatch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  MetricName,
  StateReason,
  ExtendedStatistic,
  DatapointsToAlarm,
  ActionsEnabled,
  Namespace,
  AlarmName,
  Timestamp,
  EvaluateLowSampleCountPercentile,
  Period,
  MetricId,
  AlarmArn,
  EvaluationPeriods,
  AlarmDescription,
  TreatMissingData,
  StateReasonData,
  ResourceName,
  Threshold
}
import scala.jdk.CollectionConverters._
final case class MetricAlarm(
    alarmName: Optional[AlarmName] = Optional.Absent,
    alarmArn: Optional[AlarmArn] = Optional.Absent,
    alarmDescription: Optional[AlarmDescription] = Optional.Absent,
    alarmConfigurationUpdatedTimestamp: Optional[Timestamp] = Optional.Absent,
    actionsEnabled: Optional[ActionsEnabled] = Optional.Absent,
    okActions: Optional[Iterable[ResourceName]] = Optional.Absent,
    alarmActions: Optional[Iterable[ResourceName]] = Optional.Absent,
    insufficientDataActions: Optional[Iterable[ResourceName]] = Optional.Absent,
    stateValue: Optional[zio.aws.cloudwatch.model.StateValue] = Optional.Absent,
    stateReason: Optional[StateReason] = Optional.Absent,
    stateReasonData: Optional[StateReasonData] = Optional.Absent,
    stateUpdatedTimestamp: Optional[Timestamp] = Optional.Absent,
    metricName: Optional[MetricName] = Optional.Absent,
    namespace: Optional[Namespace] = Optional.Absent,
    statistic: Optional[zio.aws.cloudwatch.model.Statistic] = Optional.Absent,
    extendedStatistic: Optional[ExtendedStatistic] = Optional.Absent,
    dimensions: Optional[Iterable[zio.aws.cloudwatch.model.Dimension]] =
      Optional.Absent,
    period: Optional[Period] = Optional.Absent,
    unit: Optional[zio.aws.cloudwatch.model.StandardUnit] = Optional.Absent,
    evaluationPeriods: Optional[EvaluationPeriods] = Optional.Absent,
    datapointsToAlarm: Optional[DatapointsToAlarm] = Optional.Absent,
    threshold: Optional[Threshold] = Optional.Absent,
    comparisonOperator: Optional[zio.aws.cloudwatch.model.ComparisonOperator] =
      Optional.Absent,
    treatMissingData: Optional[TreatMissingData] = Optional.Absent,
    evaluateLowSampleCountPercentile: Optional[
      EvaluateLowSampleCountPercentile
    ] = Optional.Absent,
    metrics: Optional[Iterable[zio.aws.cloudwatch.model.MetricDataQuery]] =
      Optional.Absent,
    thresholdMetricId: Optional[MetricId] = Optional.Absent,
    evaluationState: Optional[zio.aws.cloudwatch.model.EvaluationState] =
      Optional.Absent,
    stateTransitionedTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricAlarm = {
    import MetricAlarm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricAlarm
      .builder()
      .optionallyWith(
        alarmName.map(value => AlarmName.unwrap(value): java.lang.String)
      )(_.alarmName)
      .optionallyWith(
        alarmArn.map(value => AlarmArn.unwrap(value): java.lang.String)
      )(_.alarmArn)
      .optionallyWith(
        alarmDescription.map(value =>
          AlarmDescription.unwrap(value): java.lang.String
        )
      )(_.alarmDescription)
      .optionallyWith(
        alarmConfigurationUpdatedTimestamp.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.alarmConfigurationUpdatedTimestamp)
      .optionallyWith(
        actionsEnabled.map(value =>
          ActionsEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.actionsEnabled)
      .optionallyWith(
        okActions.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.okActions)
      .optionallyWith(
        alarmActions.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.alarmActions)
      .optionallyWith(
        insufficientDataActions.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.insufficientDataActions)
      .optionallyWith(stateValue.map(value => value.unwrap))(_.stateValue)
      .optionallyWith(
        stateReason.map(value => StateReason.unwrap(value): java.lang.String)
      )(_.stateReason)
      .optionallyWith(
        stateReasonData.map(value =>
          StateReasonData.unwrap(value): java.lang.String
        )
      )(_.stateReasonData)
      .optionallyWith(
        stateUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.stateUpdatedTimestamp)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        namespace.map(value => Namespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(
        extendedStatistic.map(value =>
          ExtendedStatistic.unwrap(value): java.lang.String
        )
      )(_.extendedStatistic)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(period.map(value => Period.unwrap(value): Integer))(
        _.period
      )
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        evaluationPeriods.map(value => EvaluationPeriods.unwrap(value): Integer)
      )(_.evaluationPeriods)
      .optionallyWith(
        datapointsToAlarm.map(value => DatapointsToAlarm.unwrap(value): Integer)
      )(_.datapointsToAlarm)
      .optionallyWith(
        threshold.map(value => Threshold.unwrap(value): java.lang.Double)
      )(_.threshold)
      .optionallyWith(comparisonOperator.map(value => value.unwrap))(
        _.comparisonOperator
      )
      .optionallyWith(
        treatMissingData.map(value =>
          TreatMissingData.unwrap(value): java.lang.String
        )
      )(_.treatMissingData)
      .optionallyWith(
        evaluateLowSampleCountPercentile.map(value =>
          EvaluateLowSampleCountPercentile.unwrap(value): java.lang.String
        )
      )(_.evaluateLowSampleCountPercentile)
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(
        thresholdMetricId.map(value => MetricId.unwrap(value): java.lang.String)
      )(_.thresholdMetricId)
      .optionallyWith(evaluationState.map(value => value.unwrap))(
        _.evaluationState
      )
      .optionallyWith(
        stateTransitionedTimestamp.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.stateTransitionedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.MetricAlarm.ReadOnly =
    zio.aws.cloudwatch.model.MetricAlarm.wrap(buildAwsValue())
}
object MetricAlarm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricAlarm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.MetricAlarm =
      zio.aws.cloudwatch.model.MetricAlarm(
        alarmName.map(value => value),
        alarmArn.map(value => value),
        alarmDescription.map(value => value),
        alarmConfigurationUpdatedTimestamp.map(value => value),
        actionsEnabled.map(value => value),
        okActions.map(value => value),
        alarmActions.map(value => value),
        insufficientDataActions.map(value => value),
        stateValue.map(value => value),
        stateReason.map(value => value),
        stateReasonData.map(value => value),
        stateUpdatedTimestamp.map(value => value),
        metricName.map(value => value),
        namespace.map(value => value),
        statistic.map(value => value),
        extendedStatistic.map(value => value),
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        period.map(value => value),
        unit.map(value => value),
        evaluationPeriods.map(value => value),
        datapointsToAlarm.map(value => value),
        threshold.map(value => value),
        comparisonOperator.map(value => value),
        treatMissingData.map(value => value),
        evaluateLowSampleCountPercentile.map(value => value),
        metrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        thresholdMetricId.map(value => value),
        evaluationState.map(value => value),
        stateTransitionedTimestamp.map(value => value)
      )
    def alarmName: Optional[AlarmName]
    def alarmArn: Optional[AlarmArn]
    def alarmDescription: Optional[AlarmDescription]
    def alarmConfigurationUpdatedTimestamp: Optional[Timestamp]
    def actionsEnabled: Optional[ActionsEnabled]
    def okActions: Optional[List[ResourceName]]
    def alarmActions: Optional[List[ResourceName]]
    def insufficientDataActions: Optional[List[ResourceName]]
    def stateValue: Optional[zio.aws.cloudwatch.model.StateValue]
    def stateReason: Optional[StateReason]
    def stateReasonData: Optional[StateReasonData]
    def stateUpdatedTimestamp: Optional[Timestamp]
    def metricName: Optional[MetricName]
    def namespace: Optional[Namespace]
    def statistic: Optional[zio.aws.cloudwatch.model.Statistic]
    def extendedStatistic: Optional[ExtendedStatistic]
    def dimensions: Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]]
    def period: Optional[Period]
    def unit: Optional[zio.aws.cloudwatch.model.StandardUnit]
    def evaluationPeriods: Optional[EvaluationPeriods]
    def datapointsToAlarm: Optional[DatapointsToAlarm]
    def threshold: Optional[Threshold]
    def comparisonOperator
        : Optional[zio.aws.cloudwatch.model.ComparisonOperator]
    def treatMissingData: Optional[TreatMissingData]
    def evaluateLowSampleCountPercentile
        : Optional[EvaluateLowSampleCountPercentile]
    def metrics
        : Optional[List[zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly]]
    def thresholdMetricId: Optional[MetricId]
    def evaluationState: Optional[zio.aws.cloudwatch.model.EvaluationState]
    def stateTransitionedTimestamp: Optional[Timestamp]
    def getAlarmName: ZIO[Any, AwsError, AlarmName] =
      AwsError.unwrapOptionField("alarmName", alarmName)
    def getAlarmArn: ZIO[Any, AwsError, AlarmArn] =
      AwsError.unwrapOptionField("alarmArn", alarmArn)
    def getAlarmDescription: ZIO[Any, AwsError, AlarmDescription] =
      AwsError.unwrapOptionField("alarmDescription", alarmDescription)
    def getAlarmConfigurationUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "alarmConfigurationUpdatedTimestamp",
        alarmConfigurationUpdatedTimestamp
      )
    def getActionsEnabled: ZIO[Any, AwsError, ActionsEnabled] =
      AwsError.unwrapOptionField("actionsEnabled", actionsEnabled)
    def getOkActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("okActions", okActions)
    def getAlarmActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("alarmActions", alarmActions)
    def getInsufficientDataActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField(
        "insufficientDataActions",
        insufficientDataActions
      )
    def getStateValue: ZIO[Any, AwsError, zio.aws.cloudwatch.model.StateValue] =
      AwsError.unwrapOptionField("stateValue", stateValue)
    def getStateReason: ZIO[Any, AwsError, StateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getStateReasonData: ZIO[Any, AwsError, StateReasonData] =
      AwsError.unwrapOptionField("stateReasonData", stateReasonData)
    def getStateUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stateUpdatedTimestamp", stateUpdatedTimestamp)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getNamespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getStatistic: ZIO[Any, AwsError, zio.aws.cloudwatch.model.Statistic] =
      AwsError.unwrapOptionField("statistic", statistic)
    def getExtendedStatistic: ZIO[Any, AwsError, ExtendedStatistic] =
      AwsError.unwrapOptionField("extendedStatistic", extendedStatistic)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getPeriod: ZIO[Any, AwsError, Period] =
      AwsError.unwrapOptionField("period", period)
    def getUnit: ZIO[Any, AwsError, zio.aws.cloudwatch.model.StandardUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getEvaluationPeriods: ZIO[Any, AwsError, EvaluationPeriods] =
      AwsError.unwrapOptionField("evaluationPeriods", evaluationPeriods)
    def getDatapointsToAlarm: ZIO[Any, AwsError, DatapointsToAlarm] =
      AwsError.unwrapOptionField("datapointsToAlarm", datapointsToAlarm)
    def getThreshold: ZIO[Any, AwsError, Threshold] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getComparisonOperator
        : ZIO[Any, AwsError, zio.aws.cloudwatch.model.ComparisonOperator] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperator)
    def getTreatMissingData: ZIO[Any, AwsError, TreatMissingData] =
      AwsError.unwrapOptionField("treatMissingData", treatMissingData)
    def getEvaluateLowSampleCountPercentile
        : ZIO[Any, AwsError, EvaluateLowSampleCountPercentile] =
      AwsError.unwrapOptionField(
        "evaluateLowSampleCountPercentile",
        evaluateLowSampleCountPercentile
      )
    def getMetrics: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metrics)
    def getThresholdMetricId: ZIO[Any, AwsError, MetricId] =
      AwsError.unwrapOptionField("thresholdMetricId", thresholdMetricId)
    def getEvaluationState
        : ZIO[Any, AwsError, zio.aws.cloudwatch.model.EvaluationState] =
      AwsError.unwrapOptionField("evaluationState", evaluationState)
    def getStateTransitionedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "stateTransitionedTimestamp",
        stateTransitionedTimestamp
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricAlarm
  ) extends zio.aws.cloudwatch.model.MetricAlarm.ReadOnly {
    override val alarmName: Optional[AlarmName] = zio.aws.core.internal
      .optionalFromNullable(impl.alarmName())
      .map(value => zio.aws.cloudwatch.model.primitives.AlarmName(value))
    override val alarmArn: Optional[AlarmArn] = zio.aws.core.internal
      .optionalFromNullable(impl.alarmArn())
      .map(value => zio.aws.cloudwatch.model.primitives.AlarmArn(value))
    override val alarmDescription: Optional[AlarmDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmDescription())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.AlarmDescription(value)
        )
    override val alarmConfigurationUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmConfigurationUpdatedTimestamp())
        .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
    override val actionsEnabled: Optional[ActionsEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsEnabled())
        .map(value => zio.aws.cloudwatch.model.primitives.ActionsEnabled(value))
    override val okActions: Optional[List[ResourceName]] = zio.aws.core.internal
      .optionalFromNullable(impl.okActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.primitives.ResourceName(item)
        }.toList
      )
    override val alarmActions: Optional[List[ResourceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.primitives.ResourceName(item)
          }.toList
        )
    override val insufficientDataActions: Optional[List[ResourceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insufficientDataActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.primitives.ResourceName(item)
          }.toList
        )
    override val stateValue: Optional[zio.aws.cloudwatch.model.StateValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateValue())
        .map(value => zio.aws.cloudwatch.model.StateValue.wrap(value))
    override val stateReason: Optional[StateReason] = zio.aws.core.internal
      .optionalFromNullable(impl.stateReason())
      .map(value => zio.aws.cloudwatch.model.primitives.StateReason(value))
    override val stateReasonData: Optional[StateReasonData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReasonData())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.StateReasonData(value)
        )
    override val stateUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateUpdatedTimestamp())
        .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricName(value))
    override val namespace: Optional[Namespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => zio.aws.cloudwatch.model.primitives.Namespace(value))
    override val statistic: Optional[zio.aws.cloudwatch.model.Statistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value => zio.aws.cloudwatch.model.Statistic.wrap(value))
    override val extendedStatistic: Optional[ExtendedStatistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendedStatistic())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.ExtendedStatistic(value)
        )
    override val dimensions
        : Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Dimension.wrap(item)
          }.toList
        )
    override val period: Optional[Period] = zio.aws.core.internal
      .optionalFromNullable(impl.period())
      .map(value => zio.aws.cloudwatch.model.primitives.Period(value))
    override val unit: Optional[zio.aws.cloudwatch.model.StandardUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.cloudwatch.model.StandardUnit.wrap(value))
    override val evaluationPeriods: Optional[EvaluationPeriods] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationPeriods())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.EvaluationPeriods(value)
        )
    override val datapointsToAlarm: Optional[DatapointsToAlarm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datapointsToAlarm())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.DatapointsToAlarm(value)
        )
    override val threshold: Optional[Threshold] = zio.aws.core.internal
      .optionalFromNullable(impl.threshold())
      .map(value => zio.aws.cloudwatch.model.primitives.Threshold(value))
    override val comparisonOperator
        : Optional[zio.aws.cloudwatch.model.ComparisonOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comparisonOperator())
        .map(value => zio.aws.cloudwatch.model.ComparisonOperator.wrap(value))
    override val treatMissingData: Optional[TreatMissingData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.treatMissingData())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.TreatMissingData(value)
        )
    override val evaluateLowSampleCountPercentile
        : Optional[EvaluateLowSampleCountPercentile] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluateLowSampleCountPercentile())
      .map(value =>
        zio.aws.cloudwatch.model.primitives
          .EvaluateLowSampleCountPercentile(value)
      )
    override val metrics
        : Optional[List[zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.MetricDataQuery.wrap(item)
          }.toList
        )
    override val thresholdMetricId: Optional[MetricId] = zio.aws.core.internal
      .optionalFromNullable(impl.thresholdMetricId())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricId(value))
    override val evaluationState
        : Optional[zio.aws.cloudwatch.model.EvaluationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationState())
        .map(value => zio.aws.cloudwatch.model.EvaluationState.wrap(value))
    override val stateTransitionedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateTransitionedTimestamp())
        .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricAlarm
  ): zio.aws.cloudwatch.model.MetricAlarm.ReadOnly = new Wrapper(impl)
}
