package zio.aws.cloudwatch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  MetricLabel,
  ReturnData,
  AccountId,
  Period,
  MetricId,
  MetricExpression
}
import scala.jdk.CollectionConverters._
final case class MetricDataQuery(
    id: MetricId,
    metricStat: Optional[zio.aws.cloudwatch.model.MetricStat] = Optional.Absent,
    expression: Optional[MetricExpression] = Optional.Absent,
    label: Optional[MetricLabel] = Optional.Absent,
    returnData: Optional[ReturnData] = Optional.Absent,
    period: Optional[Period] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery = {
    import MetricDataQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery
      .builder()
      .id(MetricId.unwrap(id): java.lang.String)
      .optionallyWith(metricStat.map(value => value.buildAwsValue()))(
        _.metricStat
      )
      .optionallyWith(
        expression.map(value =>
          MetricExpression.unwrap(value): java.lang.String
        )
      )(_.expression)
      .optionallyWith(
        label.map(value => MetricLabel.unwrap(value): java.lang.String)
      )(_.label)
      .optionallyWith(
        returnData.map(value => ReturnData.unwrap(value): java.lang.Boolean)
      )(_.returnData)
      .optionallyWith(period.map(value => Period.unwrap(value): Integer))(
        _.period
      )
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly =
    zio.aws.cloudwatch.model.MetricDataQuery.wrap(buildAwsValue())
}
object MetricDataQuery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.MetricDataQuery =
      zio.aws.cloudwatch.model.MetricDataQuery(
        id,
        metricStat.map(value => value.asEditable),
        expression.map(value => value),
        label.map(value => value),
        returnData.map(value => value),
        period.map(value => value),
        accountId.map(value => value)
      )
    def id: MetricId
    def metricStat: Optional[zio.aws.cloudwatch.model.MetricStat.ReadOnly]
    def expression: Optional[MetricExpression]
    def label: Optional[MetricLabel]
    def returnData: Optional[ReturnData]
    def period: Optional[Period]
    def accountId: Optional[AccountId]
    def getId: ZIO[Any, Nothing, MetricId] = ZIO.succeed(id)
    def getMetricStat
        : ZIO[Any, AwsError, zio.aws.cloudwatch.model.MetricStat.ReadOnly] =
      AwsError.unwrapOptionField("metricStat", metricStat)
    def getExpression: ZIO[Any, AwsError, MetricExpression] =
      AwsError.unwrapOptionField("expression", expression)
    def getLabel: ZIO[Any, AwsError, MetricLabel] =
      AwsError.unwrapOptionField("label", label)
    def getReturnData: ZIO[Any, AwsError, ReturnData] =
      AwsError.unwrapOptionField("returnData", returnData)
    def getPeriod: ZIO[Any, AwsError, Period] =
      AwsError.unwrapOptionField("period", period)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery
  ) extends zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly {
    override val id: MetricId =
      zio.aws.cloudwatch.model.primitives.MetricId(impl.id())
    override val metricStat
        : Optional[zio.aws.cloudwatch.model.MetricStat.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricStat())
        .map(value => zio.aws.cloudwatch.model.MetricStat.wrap(value))
    override val expression: Optional[MetricExpression] = zio.aws.core.internal
      .optionalFromNullable(impl.expression())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricExpression(value))
    override val label: Optional[MetricLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricLabel(value))
    override val returnData: Optional[ReturnData] = zio.aws.core.internal
      .optionalFromNullable(impl.returnData())
      .map(value => zio.aws.cloudwatch.model.primitives.ReturnData(value))
    override val period: Optional[Period] = zio.aws.core.internal
      .optionalFromNullable(impl.period())
      .map(value => zio.aws.cloudwatch.model.primitives.Period(value))
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.cloudwatch.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery
  ): zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly = new Wrapper(impl)
}
