package zio.aws.cloudwatch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudwatch.model.primitives.{
  DatapointValue,
  Timestamp,
  MetricLabel,
  MetricId
}
import scala.jdk.CollectionConverters._
final case class MetricDataResult(
    id: Optional[MetricId] = Optional.Absent,
    label: Optional[MetricLabel] = Optional.Absent,
    timestamps: Optional[Iterable[Timestamp]] = Optional.Absent,
    values: Optional[Iterable[DatapointValue]] = Optional.Absent,
    statusCode: Optional[zio.aws.cloudwatch.model.StatusCode] = Optional.Absent,
    messages: Optional[Iterable[zio.aws.cloudwatch.model.MessageData]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricDataResult = {
    import MetricDataResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricDataResult
      .builder()
      .optionallyWith(
        id.map(value => MetricId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        label.map(value => MetricLabel.unwrap(value): java.lang.String)
      )(_.label)
      .optionallyWith(
        timestamps.map(value =>
          value.map { item =>
            Timestamp.unwrap(item): Instant
          }.asJavaCollection
        )
      )(_.timestamps)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            DatapointValue.unwrap(item): java.lang.Double
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(
        messages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.messages)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.MetricDataResult.ReadOnly =
    zio.aws.cloudwatch.model.MetricDataResult.wrap(buildAwsValue())
}
object MetricDataResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricDataResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.MetricDataResult =
      zio.aws.cloudwatch.model.MetricDataResult(
        id.map(value => value),
        label.map(value => value),
        timestamps.map(value => value),
        values.map(value => value),
        statusCode.map(value => value),
        messages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: Optional[MetricId]
    def label: Optional[MetricLabel]
    def timestamps: Optional[List[Timestamp]]
    def values: Optional[List[DatapointValue]]
    def statusCode: Optional[zio.aws.cloudwatch.model.StatusCode]
    def messages: Optional[List[zio.aws.cloudwatch.model.MessageData.ReadOnly]]
    def getId: ZIO[Any, AwsError, MetricId] =
      AwsError.unwrapOptionField("id", id)
    def getLabel: ZIO[Any, AwsError, MetricLabel] =
      AwsError.unwrapOptionField("label", label)
    def getTimestamps: ZIO[Any, AwsError, List[Timestamp]] =
      AwsError.unwrapOptionField("timestamps", timestamps)
    def getValues: ZIO[Any, AwsError, List[DatapointValue]] =
      AwsError.unwrapOptionField("values", values)
    def getStatusCode: ZIO[Any, AwsError, zio.aws.cloudwatch.model.StatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getMessages: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MessageData.ReadOnly
    ]] = AwsError.unwrapOptionField("messages", messages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricDataResult
  ) extends zio.aws.cloudwatch.model.MetricDataResult.ReadOnly {
    override val id: Optional[MetricId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricId(value))
    override val label: Optional[MetricLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricLabel(value))
    override val timestamps: Optional[List[Timestamp]] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.primitives.Timestamp(item)
        }.toList
      )
    override val values: Optional[List[DatapointValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.primitives.DatapointValue(item)
        }.toList
      )
    override val statusCode: Optional[zio.aws.cloudwatch.model.StatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value => zio.aws.cloudwatch.model.StatusCode.wrap(value))
    override val messages
        : Optional[List[zio.aws.cloudwatch.model.MessageData.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.MessageData.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricDataResult
  ): zio.aws.cloudwatch.model.MetricDataResult.ReadOnly = new Wrapper(impl)
}
