package zio.aws.cloudwatch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  StorageResolution,
  DatapointValue,
  Timestamp,
  MetricName
}
import scala.jdk.CollectionConverters._
final case class MetricDatum(
    metricName: MetricName,
    dimensions: Optional[Iterable[zio.aws.cloudwatch.model.Dimension]] =
      Optional.Absent,
    timestamp: Optional[Timestamp] = Optional.Absent,
    value: Optional[DatapointValue] = Optional.Absent,
    statisticValues: Optional[zio.aws.cloudwatch.model.StatisticSet] =
      Optional.Absent,
    values: Optional[Iterable[DatapointValue]] = Optional.Absent,
    counts: Optional[Iterable[DatapointValue]] = Optional.Absent,
    unit: Optional[zio.aws.cloudwatch.model.StandardUnit] = Optional.Absent,
    storageResolution: Optional[StorageResolution] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricDatum = {
    import MetricDatum.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricDatum
      .builder()
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(
        value.map(value => DatapointValue.unwrap(value): java.lang.Double)
      )(_.value)
      .optionallyWith(statisticValues.map(value => value.buildAwsValue()))(
        _.statisticValues
      )
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            DatapointValue.unwrap(item): java.lang.Double
          }.asJavaCollection
        )
      )(_.values)
      .optionallyWith(
        counts.map(value =>
          value.map { item =>
            DatapointValue.unwrap(item): java.lang.Double
          }.asJavaCollection
        )
      )(_.counts)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        storageResolution.map(value => StorageResolution.unwrap(value): Integer)
      )(_.storageResolution)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.MetricDatum.ReadOnly =
    zio.aws.cloudwatch.model.MetricDatum.wrap(buildAwsValue())
}
object MetricDatum {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricDatum
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.MetricDatum =
      zio.aws.cloudwatch.model.MetricDatum(
        metricName,
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        timestamp.map(value => value),
        value.map(value => value),
        statisticValues.map(value => value.asEditable),
        values.map(value => value),
        counts.map(value => value),
        unit.map(value => value),
        storageResolution.map(value => value)
      )
    def metricName: MetricName
    def dimensions: Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]]
    def timestamp: Optional[Timestamp]
    def value: Optional[DatapointValue]
    def statisticValues
        : Optional[zio.aws.cloudwatch.model.StatisticSet.ReadOnly]
    def values: Optional[List[DatapointValue]]
    def counts: Optional[List[DatapointValue]]
    def unit: Optional[zio.aws.cloudwatch.model.StandardUnit]
    def storageResolution: Optional[StorageResolution]
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getValue: ZIO[Any, AwsError, DatapointValue] =
      AwsError.unwrapOptionField("value", value)
    def getStatisticValues
        : ZIO[Any, AwsError, zio.aws.cloudwatch.model.StatisticSet.ReadOnly] =
      AwsError.unwrapOptionField("statisticValues", statisticValues)
    def getValues: ZIO[Any, AwsError, List[DatapointValue]] =
      AwsError.unwrapOptionField("values", values)
    def getCounts: ZIO[Any, AwsError, List[DatapointValue]] =
      AwsError.unwrapOptionField("counts", counts)
    def getUnit: ZIO[Any, AwsError, zio.aws.cloudwatch.model.StandardUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getStorageResolution: ZIO[Any, AwsError, StorageResolution] =
      AwsError.unwrapOptionField("storageResolution", storageResolution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricDatum
  ) extends zio.aws.cloudwatch.model.MetricDatum.ReadOnly {
    override val metricName: MetricName =
      zio.aws.cloudwatch.model.primitives.MetricName(impl.metricName())
    override val dimensions
        : Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Dimension.wrap(item)
          }.toList
        )
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
    override val value: Optional[DatapointValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.cloudwatch.model.primitives.DatapointValue(value))
    override val statisticValues
        : Optional[zio.aws.cloudwatch.model.StatisticSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statisticValues())
        .map(value => zio.aws.cloudwatch.model.StatisticSet.wrap(value))
    override val values: Optional[List[DatapointValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.primitives.DatapointValue(item)
        }.toList
      )
    override val counts: Optional[List[DatapointValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.counts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.primitives.DatapointValue(item)
        }.toList
      )
    override val unit: Optional[zio.aws.cloudwatch.model.StandardUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.cloudwatch.model.StandardUnit.wrap(value))
    override val storageResolution: Optional[StorageResolution] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageResolution())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.StorageResolution(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricDatum
  ): zio.aws.cloudwatch.model.MetricDatum.ReadOnly = new Wrapper(impl)
}
