package zio.aws.cloudwatch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MetricMathAnomalyDetector(
    metricDataQueries: Optional[
      Iterable[zio.aws.cloudwatch.model.MetricDataQuery]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricMathAnomalyDetector = {
    import MetricMathAnomalyDetector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricMathAnomalyDetector
      .builder()
      .optionallyWith(
        metricDataQueries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricDataQueries)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.MetricMathAnomalyDetector.ReadOnly =
    zio.aws.cloudwatch.model.MetricMathAnomalyDetector.wrap(buildAwsValue())
}
object MetricMathAnomalyDetector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricMathAnomalyDetector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.MetricMathAnomalyDetector =
      zio.aws.cloudwatch.model.MetricMathAnomalyDetector(
        metricDataQueries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricDataQueries
        : Optional[List[zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly]]
    def getMetricDataQueries: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly
    ]] = AwsError.unwrapOptionField("metricDataQueries", metricDataQueries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricMathAnomalyDetector
  ) extends zio.aws.cloudwatch.model.MetricMathAnomalyDetector.ReadOnly {
    override val metricDataQueries
        : Optional[List[zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricDataQueries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.MetricDataQuery.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricMathAnomalyDetector
  ): zio.aws.cloudwatch.model.MetricMathAnomalyDetector.ReadOnly = new Wrapper(
    impl
  )
}
