package zio.aws.cloudwatch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{Stat, Period}
import scala.jdk.CollectionConverters._
final case class MetricStat(
    metric: zio.aws.cloudwatch.model.Metric,
    period: Period,
    stat: Stat,
    unit: Optional[zio.aws.cloudwatch.model.StandardUnit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricStat = {
    import MetricStat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricStat
      .builder()
      .metric(metric.buildAwsValue())
      .period(Period.unwrap(period): Integer)
      .stat(Stat.unwrap(stat): java.lang.String)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.MetricStat.ReadOnly =
    zio.aws.cloudwatch.model.MetricStat.wrap(buildAwsValue())
}
object MetricStat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricStat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.MetricStat =
      zio.aws.cloudwatch.model.MetricStat(
        metric.asEditable,
        period,
        stat,
        unit.map(value => value)
      )
    def metric: zio.aws.cloudwatch.model.Metric.ReadOnly
    def period: Period
    def stat: Stat
    def unit: Optional[zio.aws.cloudwatch.model.StandardUnit]
    def getMetric: ZIO[Any, Nothing, zio.aws.cloudwatch.model.Metric.ReadOnly] =
      ZIO.succeed(metric)
    def getPeriod: ZIO[Any, Nothing, Period] = ZIO.succeed(period)
    def getStat: ZIO[Any, Nothing, Stat] = ZIO.succeed(stat)
    def getUnit: ZIO[Any, AwsError, zio.aws.cloudwatch.model.StandardUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStat
  ) extends zio.aws.cloudwatch.model.MetricStat.ReadOnly {
    override val metric: zio.aws.cloudwatch.model.Metric.ReadOnly =
      zio.aws.cloudwatch.model.Metric.wrap(impl.metric())
    override val period: Period =
      zio.aws.cloudwatch.model.primitives.Period(impl.period())
    override val stat: Stat =
      zio.aws.cloudwatch.model.primitives.Stat(impl.stat())
    override val unit: Optional[zio.aws.cloudwatch.model.StandardUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.cloudwatch.model.StandardUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStat
  ): zio.aws.cloudwatch.model.MetricStat.ReadOnly = new Wrapper(impl)
}
