package zio.aws.cloudwatch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudwatch.model.primitives.{
  MetricStreamState,
  MetricStreamName,
  Timestamp,
  AmazonResourceName
}
import scala.jdk.CollectionConverters._
final case class MetricStreamEntry(
    arn: Optional[AmazonResourceName] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    lastUpdateDate: Optional[Timestamp] = Optional.Absent,
    name: Optional[MetricStreamName] = Optional.Absent,
    firehoseArn: Optional[AmazonResourceName] = Optional.Absent,
    state: Optional[MetricStreamState] = Optional.Absent,
    outputFormat: Optional[zio.aws.cloudwatch.model.MetricStreamOutputFormat] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricStreamEntry = {
    import MetricStreamEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamEntry
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastUpdateDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateDate)
      .optionallyWith(
        name.map(value => MetricStreamName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        firehoseArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.firehoseArn)
      .optionallyWith(
        state.map(value => MetricStreamState.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(outputFormat.map(value => value.unwrap))(_.outputFormat)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.MetricStreamEntry.ReadOnly =
    zio.aws.cloudwatch.model.MetricStreamEntry.wrap(buildAwsValue())
}
object MetricStreamEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.MetricStreamEntry =
      zio.aws.cloudwatch.model.MetricStreamEntry(
        arn.map(value => value),
        creationDate.map(value => value),
        lastUpdateDate.map(value => value),
        name.map(value => value),
        firehoseArn.map(value => value),
        state.map(value => value),
        outputFormat.map(value => value)
      )
    def arn: Optional[AmazonResourceName]
    def creationDate: Optional[Timestamp]
    def lastUpdateDate: Optional[Timestamp]
    def name: Optional[MetricStreamName]
    def firehoseArn: Optional[AmazonResourceName]
    def state: Optional[MetricStreamState]
    def outputFormat
        : Optional[zio.aws.cloudwatch.model.MetricStreamOutputFormat]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastUpdateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateDate", lastUpdateDate)
    def getName: ZIO[Any, AwsError, MetricStreamName] =
      AwsError.unwrapOptionField("name", name)
    def getFirehoseArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("firehoseArn", firehoseArn)
    def getState: ZIO[Any, AwsError, MetricStreamState] =
      AwsError.unwrapOptionField("state", state)
    def getOutputFormat: ZIO[
      Any,
      AwsError,
      zio.aws.cloudwatch.model.MetricStreamOutputFormat
    ] = AwsError.unwrapOptionField("outputFormat", outputFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamEntry
  ) extends zio.aws.cloudwatch.model.MetricStreamEntry.ReadOnly {
    override val arn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.cloudwatch.model.primitives.AmazonResourceName(value)
      )
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
    override val lastUpdateDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateDate())
      .map(value => zio.aws.cloudwatch.model.primitives.Timestamp(value))
    override val name: Optional[MetricStreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricStreamName(value))
    override val firehoseArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firehoseArn())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.AmazonResourceName(value)
        )
    override val state: Optional[MetricStreamState] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value =>
        zio.aws.cloudwatch.model.primitives.MetricStreamState(value)
      )
    override val outputFormat
        : Optional[zio.aws.cloudwatch.model.MetricStreamOutputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputFormat())
        .map(value =>
          zio.aws.cloudwatch.model.MetricStreamOutputFormat.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamEntry
  ): zio.aws.cloudwatch.model.MetricStreamEntry.ReadOnly = new Wrapper(impl)
}
