package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{MetricName, Namespace}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MetricStreamFilter(
    namespace: Optional[Namespace] = Optional.Absent,
    metricNames: Optional[Iterable[MetricName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter = {
    import MetricStreamFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter
      .builder()
      .optionallyWith(
        namespace.map(value => Namespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        metricNames.map(value =>
          value.map { item =>
            MetricName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.metricNames)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly =
    zio.aws.cloudwatch.model.MetricStreamFilter.wrap(buildAwsValue())
}
object MetricStreamFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.MetricStreamFilter =
      zio.aws.cloudwatch.model.MetricStreamFilter(
        namespace.map(value => value),
        metricNames.map(value => value)
      )
    def namespace: Optional[Namespace]
    def metricNames: Optional[List[MetricName]]
    def getNamespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getMetricNames: ZIO[Any, AwsError, List[MetricName]] =
      AwsError.unwrapOptionField("metricNames", metricNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter
  ) extends zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly {
    override val namespace: Optional[Namespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => zio.aws.cloudwatch.model.primitives.Namespace(value))
    override val metricNames: Optional[List[MetricName]] = zio.aws.core.internal
      .optionalFromNullable(impl.metricNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.primitives.MetricName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamFilter
  ): zio.aws.cloudwatch.model.MetricStreamFilter.ReadOnly = new Wrapper(impl)
}
