package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.MetricStreamStatistic
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MetricStreamStatisticsConfiguration(
    includeMetrics: Iterable[
      zio.aws.cloudwatch.model.MetricStreamStatisticsMetric
    ],
    additionalStatistics: Iterable[MetricStreamStatistic]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration = {
    import MetricStreamStatisticsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration
      .builder()
      .includeMetrics(includeMetrics.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .additionalStatistics(additionalStatistics.map { item =>
        MetricStreamStatistic.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly =
    zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration
      .wrap(buildAwsValue())
}
object MetricStreamStatisticsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration =
      zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration(
        includeMetrics.map { item =>
          item.asEditable
        },
        additionalStatistics
      )
    def includeMetrics
        : List[zio.aws.cloudwatch.model.MetricStreamStatisticsMetric.ReadOnly]
    def additionalStatistics: List[MetricStreamStatistic]
    def getIncludeMetrics: ZIO[Any, Nothing, List[
      zio.aws.cloudwatch.model.MetricStreamStatisticsMetric.ReadOnly
    ]] = ZIO.succeed(includeMetrics)
    def getAdditionalStatistics
        : ZIO[Any, Nothing, List[MetricStreamStatistic]] =
      ZIO.succeed(additionalStatistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration
  ) extends zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly {
    override val includeMetrics
        : List[zio.aws.cloudwatch.model.MetricStreamStatisticsMetric.ReadOnly] =
      impl
        .includeMetrics()
        .asScala
        .map { item =>
          zio.aws.cloudwatch.model.MetricStreamStatisticsMetric.wrap(item)
        }
        .toList
    override val additionalStatistics: List[MetricStreamStatistic] = impl
      .additionalStatistics()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.primitives.MetricStreamStatistic(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MetricStreamStatisticsConfiguration
  ): zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly =
    new Wrapper(impl)
}
